/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mttr;

import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TransientProjectActionFactory;
import hudson.model.listeners.RunListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import jenkins.plugins.model.BuildMessage;
import jenkins.plugins.model.MTTFMetric;
import jenkins.plugins.model.MTTRMetric;
import jenkins.plugins.model.StandardDeviationMetric;
import jenkins.plugins.util.GraphUtil;
import jenkins.plugins.util.ReadUtil;
import jenkins.plugins.util.StoreUtil;
import org.jfree.chart.JFreeChart;

public class MetricsAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(MetricsAction.class.getName());
    public static final String MTTR_LAST_7_DAYS = "mttrLast7days";
    public static final String MTTR_LAST_30_DAYS = "mttrLast30days";
    public static final String MTTR_ALL_BUILDS = "mttrAllBuilds";
    public static final String MTTF_LAST_7_DAYS = "mttfLast7days";
    public static final String MTTF_LAST_30_DAYS = "mttfLast30days";
    public static final String MTTF_ALL_BUILDS = "mttfAllBuilds";
    public static final String STDDEV_LAST_7_DAYS = "stddevLast7days";
    public static final String STDDEV_LAST_30_DAYS = "stddevLast30days";
    public static final String STDDEV_ALL_BUILDS = "stddevAllBuilds";
    public static final String ALL_BUILDS_FILE_NAME = "all_builds.mr";
    private AbstractProject project;

    public MetricsAction(AbstractProject project) {
        this.project = project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public Map<String, String> getMetricMap() throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)ReadUtil.getJobProperties(MTTRMetric.class, (Job)this.project));
        properties.putAll((Map<?, ?>)ReadUtil.getJobProperties(MTTFMetric.class, (Job)this.project));
        properties.putAll((Map<?, ?>)ReadUtil.getJobProperties(StandardDeviationMetric.class, (Job)this.project));
        result.put(MTTR_LAST_7_DAYS, this.getPropertyOrDefault(properties, MTTR_LAST_7_DAYS, "0"));
        result.put(MTTR_LAST_30_DAYS, this.getPropertyOrDefault(properties, MTTR_LAST_30_DAYS, "0"));
        result.put(MTTR_ALL_BUILDS, this.getPropertyOrDefault(properties, MTTR_ALL_BUILDS, "0"));
        result.put(MTTF_LAST_7_DAYS, this.getPropertyOrDefault(properties, MTTF_LAST_7_DAYS, "0"));
        result.put(MTTF_LAST_30_DAYS, this.getPropertyOrDefault(properties, MTTF_LAST_30_DAYS, "0"));
        result.put(MTTF_ALL_BUILDS, this.getPropertyOrDefault(properties, MTTF_ALL_BUILDS, "0"));
        result.put(STDDEV_LAST_7_DAYS, this.getPropertyOrDefault(properties, STDDEV_LAST_7_DAYS, "0"));
        result.put(STDDEV_LAST_30_DAYS, this.getPropertyOrDefault(properties, STDDEV_LAST_30_DAYS, "0"));
        result.put(STDDEV_ALL_BUILDS, this.getPropertyOrDefault(properties, STDDEV_ALL_BUILDS, "0"));
        return result;
    }

    private String getPropertyOrDefault(Properties properties, String key, String defaultValue) {
        String duration = properties.containsKey(key) ? properties.getProperty(key) : defaultValue;
        return Util.getPastTimeString((long)Long.parseLong(duration));
    }

    @Extension
    public static class RunListenerImpl
    extends RunListener<Run> {
        public void onCompleted(Run run, TaskListener listener) {
            File storeFile = new File(run.getParent().getRootDir().getAbsolutePath() + File.separator + MetricsAction.ALL_BUILDS_FILE_NAME);
            StoreUtil.storeBuildMessages(storeFile, run);
            List<BuildMessage> buildMessages = ReadUtil.getBuildMessageFrom(storeFile);
            MTTRMetric mttrLast7DayInfo = new MTTRMetric(MetricsAction.MTTR_LAST_7_DAYS, this.cutListByAgoDays(buildMessages, -7));
            MTTRMetric mttrLast30DayInfo = new MTTRMetric(MetricsAction.MTTR_LAST_30_DAYS, this.cutListByAgoDays(buildMessages, -30));
            MTTRMetric mttrAllFailedInfo = new MTTRMetric(MetricsAction.MTTR_ALL_BUILDS, buildMessages);
            StoreUtil.storeBuildMetric(MTTRMetric.class, run, mttrLast7DayInfo, mttrLast30DayInfo, mttrAllFailedInfo);
            MTTFMetric mttfLast7DayInfo = new MTTFMetric(MetricsAction.MTTF_LAST_7_DAYS, this.cutListByAgoDays(buildMessages, -7));
            MTTFMetric mttfLast30DayInfo = new MTTFMetric(MetricsAction.MTTF_LAST_30_DAYS, this.cutListByAgoDays(buildMessages, -30));
            MTTFMetric mttfAllBuilds = new MTTFMetric(MetricsAction.MTTF_ALL_BUILDS, buildMessages);
            StoreUtil.storeBuildMetric(MTTFMetric.class, run, mttfLast7DayInfo, mttfLast30DayInfo, mttfAllBuilds);
            StandardDeviationMetric stdDevLast7DayInfo = new StandardDeviationMetric(MetricsAction.STDDEV_LAST_7_DAYS, this.cutListByAgoDays(buildMessages, -7));
            StandardDeviationMetric stdDevLast30DayInfo = new StandardDeviationMetric(MetricsAction.STDDEV_LAST_30_DAYS, this.cutListByAgoDays(buildMessages, -30));
            StandardDeviationMetric stdDevAllFailedInfo = new StandardDeviationMetric(MetricsAction.STDDEV_ALL_BUILDS, buildMessages);
            StoreUtil.storeBuildMetric(StandardDeviationMetric.class, run, stdDevLast7DayInfo, stdDevLast30DayInfo, stdDevAllFailedInfo);
            JFreeChart stddevChart = GraphUtil.generateStdDevGraph("Standard Deviation of Build Time", buildMessages);
            StoreUtil.storeGraph(StandardDeviationMetric.class, run, stddevChart);
        }

        private List<BuildMessage> cutListByAgoDays(List<BuildMessage> builds, int daysAgo) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, daysAgo);
            ArrayList subList = Lists.newArrayList();
            for (BuildMessage build : builds) {
                if (build.getStartTime() <= calendar.getTimeInMillis()) continue;
                subList.add(build);
            }
            return subList;
        }
    }

    @Extension
    public static final class ProjectActionFactory
    extends TransientProjectActionFactory {
        public Collection<? extends Action> createFor(AbstractProject target) {
            return Collections.singleton(new MetricsAction(target));
        }
    }
}

