/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.model;

import com.google.common.collect.Ordering;
import hudson.model.Result;
import java.util.List;
import jenkins.plugins.model.AggregateBuildMetric;
import jenkins.plugins.model.BuildMessage;

public class MTTFMetric
implements AggregateBuildMetric {
    private String metricName;
    private long metricValue;
    private int occurences;

    public MTTFMetric(String metricName, List<BuildMessage> builds) {
        this.metricName = metricName;
        this.initialize(Ordering.natural().sortedCopy(builds));
    }

    private void initialize(List<BuildMessage> builds) {
        long successBuildDate = 0L;
        long totalSuccessTime = 0L;
        for (BuildMessage build : builds) {
            String result = build.getResult();
            if (result == null) continue;
            if (!result.equals(Result.FAILURE.toString())) {
                if (successBuildDate != 0L) continue;
                successBuildDate = build.getStartTime();
                continue;
            }
            if (successBuildDate == 0L) continue;
            long successLastTime = build.getStartTime() - successBuildDate;
            totalSuccessTime += successLastTime;
            ++this.occurences;
            successBuildDate = 0L;
        }
        this.metricValue = this.occurences > 0 ? totalSuccessTime / (long)this.occurences : 0L;
    }

    @Override
    public int getOccurences() {
        return this.occurences;
    }

    @Override
    public long calculateMetric() {
        return this.metricValue;
    }

    @Override
    public String getName() {
        return this.metricName;
    }
}

