/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.model;

import java.util.List;
import jenkins.plugins.model.AggregateBuildMetric;
import jenkins.plugins.model.BuildMessage;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class StandardDeviationMetric
implements AggregateBuildMetric {
    private final String name;
    private final long metric;
    private final int occurences;

    public StandardDeviationMetric(String name, List<BuildMessage> messages) {
        this.name = name;
        this.occurences = messages.size();
        SummaryStatistics statistics = new SummaryStatistics();
        for (BuildMessage m : messages) {
            statistics.addValue((double)m.getDuration());
        }
        this.metric = (long)statistics.getStandardDeviation();
    }

    private StandardDeviationMetric(String name, long metric, int occurences) {
        this.name = name;
        this.metric = metric;
        this.occurences = occurences;
    }

    @Override
    public int getOccurences() {
        return this.occurences;
    }

    @Override
    public long calculateMetric() {
        return this.metric;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static Builder newBuilderFor(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final SummaryStatistics statistics = new SummaryStatistics();
        private final String name;

        private Builder(String name) {
            this.name = name;
        }

        public void addMessage(BuildMessage message) {
            this.statistics.addValue((double)message.getDuration());
        }

        public StandardDeviationMetric build() {
            return new StandardDeviationMetric(this.name, (long)this.statistics.getStandardDeviation(), Math.toIntExact(this.statistics.getN()));
        }
    }
}

