/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.model;

import com.google.common.collect.Ordering;
import hudson.model.Result;
import java.util.List;
import java.util.logging.Logger;
import jenkins.plugins.model.AggregateBuildMetric;
import jenkins.plugins.model.BuildMessage;

public class MTTRMetric
implements AggregateBuildMetric {
    private static final Logger LOGGER = Logger.getLogger(MTTRMetric.class.getName());
    private int buildCount;
    private long totalFailedTime;
    private String name;

    public MTTRMetric(String name, List<BuildMessage> builds) {
        this.name = name;
        this.initialize(Ordering.natural().sortedCopy(builds));
    }

    @Override
    public int getOccurences() {
        return this.buildCount;
    }

    private void initialize(List<BuildMessage> builds) {
        long failedBuildDate = 0L;
        for (BuildMessage build : builds) {
            String result = build.getResult();
            if (result == null) continue;
            if (!result.equals(Result.SUCCESS.toString())) {
                if (failedBuildDate != 0L) continue;
                failedBuildDate = build.getStartTime();
                continue;
            }
            if (failedBuildDate == 0L) continue;
            long failedLastTime = build.getStartTime() - failedBuildDate;
            this.totalFailedTime += failedLastTime;
            ++this.buildCount;
            failedBuildDate = 0L;
        }
    }

    @Override
    public long calculateMetric() {
        return this.buildCount == 0 ? 0L : this.totalFailedTime / (long)this.buildCount;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

