// CHECKSTYLE:OFF

package jenkins.plugins.mttr;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code allBuildsResult}: {@code Mean time to repair for all
     * history : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mean time to repair for all history : {0}}
     */
    public static String allBuildsResult(Object arg0) {
        return holder.format("allBuildsResult", arg0);
    }

    /**
     * Key {@code allBuildsResult}: {@code Mean time to repair for all
     * history : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mean time to repair for all history : {0}}
     */
    public static Localizable _allBuildsResult(Object arg0) {
        return new Localizable(holder, "allBuildsResult", arg0);
    }

    /**
     * Key {@code last30DaysBuildsResult}: {@code Mean time to repair for
     * last 30 days : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mean time to repair for last 30 days : {0}}
     */
    public static String last30DaysBuildsResult(Object arg0) {
        return holder.format("last30DaysBuildsResult", arg0);
    }

    /**
     * Key {@code last30DaysBuildsResult}: {@code Mean time to repair for
     * last 30 days : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mean time to repair for last 30 days : {0}}
     */
    public static Localizable _last30DaysBuildsResult(Object arg0) {
        return new Localizable(holder, "last30DaysBuildsResult", arg0);
    }

    /**
     * Key {@code last7DaysBuildsColumnTitle}: {@code Last 7 days mean time
     * to repair}.
     * 
     * @return
     *     {@code Last 7 days mean time to repair}
     */
    public static String last7DaysBuildsColumnTitle() {
        return holder.format("last7DaysBuildsColumnTitle");
    }

    /**
     * Key {@code last7DaysBuildsColumnTitle}: {@code Last 7 days mean time
     * to repair}.
     * 
     * @return
     *     {@code Last 7 days mean time to repair}
     */
    public static Localizable _last7DaysBuildsColumnTitle() {
        return new Localizable(holder, "last7DaysBuildsColumnTitle");
    }

    /**
     * Key {@code allBuildsColumnTitle}: {@code All history mean time to
     * repair}.
     * 
     * @return
     *     {@code All history mean time to repair}
     */
    public static String allBuildsColumnTitle() {
        return holder.format("allBuildsColumnTitle");
    }

    /**
     * Key {@code allBuildsColumnTitle}: {@code All history mean time to
     * repair}.
     * 
     * @return
     *     {@code All history mean time to repair}
     */
    public static Localizable _allBuildsColumnTitle() {
        return new Localizable(holder, "allBuildsColumnTitle");
    }

    /**
     * Key {@code last30DaysBuildsColumnTitle}: {@code Last 30 days mean time
     * to repair}.
     * 
     * @return
     *     {@code Last 30 days mean time to repair}
     */
    public static String last30DaysBuildsColumnTitle() {
        return holder.format("last30DaysBuildsColumnTitle");
    }

    /**
     * Key {@code last30DaysBuildsColumnTitle}: {@code Last 30 days mean time
     * to repair}.
     * 
     * @return
     *     {@code Last 30 days mean time to repair}
     */
    public static Localizable _last30DaysBuildsColumnTitle() {
        return new Localizable(holder, "last30DaysBuildsColumnTitle");
    }

    /**
     * Key {@code canNotGetResult}: {@code Can't get result}.
     * 
     * @return
     *     {@code Can't get result}
     */
    public static String canNotGetResult() {
        return holder.format("canNotGetResult");
    }

    /**
     * Key {@code canNotGetResult}: {@code Can't get result}.
     * 
     * @return
     *     {@code Can't get result}
     */
    public static Localizable _canNotGetResult() {
        return new Localizable(holder, "canNotGetResult");
    }

    /**
     * Key {@code last7DaysBuildsResult}: {@code Mean time to repair for last
     *  7 days : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mean time to repair for last 7 days : {0}}
     */
    public static String last7DaysBuildsResult(Object arg0) {
        return holder.format("last7DaysBuildsResult", arg0);
    }

    /**
     * Key {@code last7DaysBuildsResult}: {@code Mean time to repair for last
     *  7 days : {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mean time to repair for last 7 days : {0}}
     */
    public static Localizable _last7DaysBuildsResult(Object arg0) {
        return new Localizable(holder, "last7DaysBuildsResult", arg0);
    }

}
