/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.buildblocker;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import hudson.plugins.buildblocker.BlockingJobsMonitor;
import hudson.plugins.buildblocker.BuildBlockerFolderProperty;
import hudson.plugins.buildblocker.BuildBlockerProperty;
import hudson.plugins.buildblocker.DefaultMonitorFactory;
import hudson.plugins.buildblocker.IBuildBlockerProperty;
import hudson.plugins.buildblocker.Messages;
import hudson.plugins.buildblocker.MonitorFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jvnet.localizer.Localizable;

@Extension(optional=true)
public class BuildBlockerQueueTaskDispatcher
extends QueueTaskDispatcher {
    private static final Logger LOG = Logger.getLogger(BuildBlockerQueueTaskDispatcher.class.getName());
    private MonitorFactory monitorFactory;

    public BuildBlockerQueueTaskDispatcher() {
        this.monitorFactory = new DefaultMonitorFactory();
    }

    BuildBlockerQueueTaskDispatcher(MonitorFactory monitorFactory) {
        this.monitorFactory = monitorFactory;
    }

    public CauseOfBlockage canRun(Queue.Item item) {
        CauseOfBlockage Job2;
        IBuildBlockerProperty property;
        if (item.task instanceof Job && (property = this.getBuildBlockerProperty(item)) != null && property.isUseBuildBlocker() && (Job2 = this.checkForBlock(item, property)) != null) {
            return Job2;
        }
        return super.canRun(item);
    }

    public CauseOfBlockage canTake(Node node, Queue.BuildableItem item) {
        CauseOfBlockage causeOfBlockage;
        IBuildBlockerProperty property = this.getBuildBlockerProperty((Queue.Item)item);
        if (property != null && property.isUseBuildBlocker() && (causeOfBlockage = this.checkForBlock(node, (Queue.Item)item, property)) != null) {
            return causeOfBlockage;
        }
        return super.canTake(node, item);
    }

    private CauseOfBlockage checkForBlock(Queue.Item item, IBuildBlockerProperty blockingJobs) {
        return this.checkForBlock(null, item, blockingJobs);
    }

    private CauseOfBlockage checkForBlock(Node node, Queue.Item item, IBuildBlockerProperty property) {
        if (property.getBlockingJobs() == null) {
            return null;
        }
        Job result = this.checkAccordingToProperties(node, item, property);
        if (result != null) {
            if (result instanceof MatrixConfiguration) {
                result = ((MatrixConfiguration)result).getParent();
            }
            return CauseOfBlockage.fromMessage((Localizable)Messages._BlockingJobIsRunning(item.getInQueueForString(), result.getDisplayName()));
        }
        return null;
    }

    private Job checkAccordingToProperties(Node node, Queue.Item item, IBuildBlockerProperty properties) {
        BlockingJobsMonitor jobsMonitor = this.monitorFactory.build(properties.getBlockingJobs());
        if (this.checkWasCalledInGlobalContext(node) && properties.getBlockLevel().isGlobal()) {
            LOG.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "checkAccordingToProperties", "calling checkAllNodesForRunningBuilds");
            Job checkAllNodesForRunningBuildsResult = jobsMonitor.checkAllNodesForRunningBuilds();
            if (this.foundBlocker(checkAllNodesForRunningBuildsResult)) {
                return checkAllNodesForRunningBuildsResult;
            }
            if (properties.getScanQueueFor().isAll()) {
                LOG.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "checkAccordingToProperties", "calling checkForQueueEntries");
                Job checkForQueueEntriesResult = jobsMonitor.checkForQueueEntries(item);
                if (this.foundBlocker(checkForQueueEntriesResult)) {
                    return checkForQueueEntriesResult;
                }
            } else if (properties.getScanQueueFor().isBuildable()) {
                LOG.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "checkAccordingToProperties", "calling checkForBuildableQueueEntries");
                Job checkForBuildableQueueEntriesResult = jobsMonitor.checkForBuildableQueueEntries(item);
                if (this.foundBlocker(checkForBuildableQueueEntriesResult)) {
                    return checkForBuildableQueueEntriesResult;
                }
            }
        }
        if (this.checkWasCalledInNodeContext(node) && properties.getBlockLevel().isNode() && !properties.getBlockLevel().isGlobal()) {
            LOG.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "checkAccordingToProperties", "calling checkNodeForRunningBuilds");
            Job checkNodeForRunningBuildsResult = jobsMonitor.checkNodeForRunningBuilds(node);
            if (this.foundBlocker(checkNodeForRunningBuildsResult)) {
                return checkNodeForRunningBuildsResult;
            }
            if (properties.getScanQueueFor().isAll()) {
                LOG.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "checkAccordingToProperties", "calling checkNodeForQueueEntries");
                Job checkNodeForQueueEntriesResult = jobsMonitor.checkNodeForQueueEntries(item, node);
                if (this.foundBlocker(checkNodeForQueueEntriesResult)) {
                    return checkNodeForQueueEntriesResult;
                }
            } else if (properties.getScanQueueFor().isBuildable()) {
                LOG.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "checkAccordingToProperties", "calling checkNodeFOrBuildableQueueEntries");
                Job checkNodeForBuildableQueueEntriesResult = jobsMonitor.checkNodeForBuildableQueueEntries(item, node);
                if (this.foundBlocker(checkNodeForBuildableQueueEntriesResult)) {
                    return checkNodeForBuildableQueueEntriesResult;
                }
            }
        }
        return null;
    }

    private boolean checkWasCalledInNodeContext(Node node) {
        return node != null;
    }

    private boolean checkWasCalledInGlobalContext(Node node) {
        return node == null;
    }

    private boolean foundBlocker(Job result) {
        return result != null;
    }

    @CheckForNull
    private IBuildBlockerProperty getBuildBlockerProperty(Queue.Item item) {
        if (!(item.task instanceof Job)) {
            if (!(item.task.getOwnerTask() instanceof Job)) {
                return null;
            }
            return (IBuildBlockerProperty)((Job)item.task.getOwnerTask()).getProperty(BuildBlockerProperty.class);
        }
        Job job = (Job)item.task;
        IBuildBlockerProperty property = (IBuildBlockerProperty)job.getProperty(BuildBlockerProperty.class);
        if (property != null && property.isUseBuildBlocker()) {
            LOG.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "getBuildBlockerProperty", "Found build blocker property on job " + job.getFullDisplayName());
            return property;
        }
        try {
            LOG.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "getBuildBlockerProperty", "checking parent getBuildBlockerFolderProperty");
            property = ((BuildBlockerFolderProperty.DescriptorImpl)Jenkins.get().getDescriptorByType(BuildBlockerFolderProperty.DescriptorImpl.class)).getBuildBlockerFolderProperty(job);
            if (property != null && property.isUseBuildBlocker()) {
                LOG.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "getBuildBlockerProperty", "Found build blocker property on parent of job " + job.getFullDisplayName());
                return property;
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            LOG.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "getBuildBlockerProperty", "Unable to check parent for build blocker property. Make sure cloudbees-folder plugin is installed.", e);
        }
        return null;
    }
}

