/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.blueoceandisplayurl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.blueocean.rest.factory.organization.AbstractOrganization;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import java.util.Set;
import jenkins.branch.MultiBranchProject;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class BlueOceanDisplayURLImpl
extends DisplayURLProvider {
    private static final Set<String> SUPPORTED_RUNS = Set.of(FreeStyleBuild.class.getName(), WorkflowRun.class.getName(), "hudson.maven.AbstractMavenBuild");
    private static final Set<String> SUPPORTED_JOBS = Set.of(WorkflowJob.class.getName(), MultiBranchProject.class.getName(), FreeStyleProject.class.getName(), "hudson.maven.AbstractMavenProject");

    @NonNull
    public String getDisplayName() {
        return "Blue Ocean";
    }

    @NonNull
    public String getName() {
        return "blueocean";
    }

    @NonNull
    public String getRoot() {
        return super.getRoot() + "blue/";
    }

    @NonNull
    public String getRunURL(Run<?, ?> run) {
        Job job;
        BlueOrganization organization = OrganizationFactory.getInstance().getContainingOrg((Item)run.getParent());
        if (organization == null || !BlueOceanDisplayURLImpl.isSupported(run)) {
            return DisplayURLProvider.getDefault().getRunURL(run);
        }
        if (run instanceof WorkflowRun && (job = (WorkflowJob)((WorkflowRun)run).getParent()).getParent() instanceof MultiBranchProject) {
            String jobURL = this.getJobURL(organization, (MultiBranchProject)job.getParent());
            return String.format("%sdetail/%s/%d/", jobURL, job.getName(), run.getNumber());
        }
        job = run.getParent();
        String jobURL = this.getJobURL(organization, job);
        return String.format("%sdetail/%s/%d/", jobURL, Util.rawEncode((String)job.getName()), run.getNumber());
    }

    @NonNull
    public String getArtifactsURL(Run<?, ?> run) {
        if (BlueOceanDisplayURLImpl.isSupported(run)) {
            return this.getRunURL(run) + "artifacts";
        }
        return DisplayURLProvider.getDefault().getArtifactsURL(run);
    }

    @NonNull
    public String getChangesURL(Run<?, ?> run) {
        if (BlueOceanDisplayURLImpl.isSupported(run)) {
            return this.getRunURL(run) + "changes";
        }
        return DisplayURLProvider.getDefault().getChangesURL(run);
    }

    @NonNull
    public String getTestsURL(Run<?, ?> run) {
        if (BlueOceanDisplayURLImpl.isSupported(run)) {
            return this.getRunURL(run) + "tests";
        }
        return DisplayURLProvider.getDefault().getTestsURL(run);
    }

    @NonNull
    public String getJobURL(Job<?, ?> job) {
        BlueOrganization organization = OrganizationFactory.getInstance().getContainingOrg(job);
        if (organization == null || !BlueOceanDisplayURLImpl.isSupported(job)) {
            return DisplayURLProvider.getDefault().getJobURL(job);
        }
        return this.getJobURL(organization, job);
    }

    @NonNull
    private String getJobURL(BlueOrganization organization, Job<?, ?> job) {
        String jobPath = job.getParent() instanceof MultiBranchProject ? BlueOceanDisplayURLImpl.getFullNameForItemGroup(organization, job.getParent()) : BlueOceanDisplayURLImpl.getFullNameForItem(organization, job);
        return String.format("%sorganizations/%s/%s/", this.getRoot(), Util.rawEncode((String)organization.getName()), Util.rawEncode((String)jobPath));
    }

    private static boolean isSupported(Run<?, ?> run) {
        return BlueOceanDisplayURLImpl.isInstance(run, SUPPORTED_RUNS);
    }

    private static boolean isSupported(Job<?, ?> job) {
        return BlueOceanDisplayURLImpl.isInstance(job, SUPPORTED_JOBS);
    }

    private static boolean isInstance(Object o, Set<String> clazzes) {
        for (String clazz : clazzes) {
            if (o == null || !o.getClass().getName().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    private String getJobURL(BlueOrganization organization, MultiBranchProject<?, ?> project) {
        return String.format("%sorganizations/%s/%s/", this.getRoot(), Util.rawEncode((String)organization.getName()), Util.rawEncode((String)BlueOceanDisplayURLImpl.getFullNameForItem(organization, project)));
    }

    private static String getFullNameForItem(@CheckForNull BlueOrganization org, @NonNull Item item) {
        ItemGroup<?> group = BlueOceanDisplayURLImpl.getBaseGroup(org);
        return Functions.getRelativeNameFrom((Item)item, group);
    }

    private static String getFullNameForItemGroup(@CheckForNull BlueOrganization org, @NonNull ItemGroup itemGroup) {
        if (itemGroup instanceof Item) {
            return BlueOceanDisplayURLImpl.getFullNameForItem(org, (Item)itemGroup);
        }
        return itemGroup.getFullName();
    }

    private static ItemGroup<?> getBaseGroup(BlueOrganization org) {
        ModifiableTopLevelItemGroup group = null;
        if (org instanceof AbstractOrganization) {
            group = ((AbstractOrganization)org).getGroup();
        }
        return group;
    }
}

