/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins;

import com.cloudbees.jenkins.plugins.BitBucketTriggerRunnable;
import hudson.Extension;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.SequentialExecutionQueue;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class BitBucketTrigger
extends Trigger<Job<?, ?>> {
    private String overrideUrl;
    private Boolean buildOnCreatedBranch;
    private static final Logger LOGGER = Logger.getLogger(BitBucketTrigger.class.getName());

    @DataBoundConstructor
    public BitBucketTrigger() {
    }

    public String getOverrideUrl() {
        return this.overrideUrl;
    }

    @DataBoundSetter
    public void setOverrideUrl(String overrideUrl) {
        this.overrideUrl = overrideUrl;
    }

    public Boolean getBuildOnCreatedBranch() {
        return this.buildOnCreatedBranch;
    }

    @DataBoundSetter
    public void setBuildOnCreatedBranch(Boolean buildOnCreatedBranch) {
        this.buildOnCreatedBranch = buildOnCreatedBranch;
    }

    public void onPost(String triggeredByUser, String payload, String branchName) {
        this.getDescriptor().queue.execute((Runnable)new BitBucketTriggerRunnable(payload, (Job)this.job, LOGGER, triggeredByUser, branchName, this.buildOnCreatedBranch != null && this.buildOnCreatedBranch != false));
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new BitBucketWebHookPollingAction());
    }

    public File getLogFile() {
        if (this.job == null) {
            throw new RuntimeException("job is null");
        }
        return new File(((Job)this.job).getRootDir(), "bitbucket-polling.log");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"bitbucketPush"})
    public static class DescriptorImpl
    extends TriggerDescriptor {
        private final transient SequentialExecutionQueue queue = new SequentialExecutionQueue(Hudson.MasterComputer.threadPoolForRemoting);

        public FormValidation doCheckOverrideUrl(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.ok();
        }

        public boolean isApplicable(Item item) {
            return item instanceof Job && SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)item) != null && item instanceof ParameterizedJobMixIn.ParameterizedJob;
        }

        public String getDisplayName() {
            return "Build when a change is pushed to BitBucket";
        }
    }

    public final class BitBucketWebHookPollingAction
    implements Action {
        long start = 0L;

        public Job<?, ?> getOwner() {
            return (Job)BitBucketTrigger.this.job;
        }

        public String getIconFileName() {
            return "clipboard.png";
        }

        public String getDisplayName() {
            return "BitBucket Hook Log";
        }

        public String getUrlName() {
            return "BitBucketPollLog";
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)BitBucketTrigger.this.getLogFile());
        }

        public void writeLogTo(XMLOutput out) throws IOException {
            this.start = new AnnotatedLargeText(BitBucketTrigger.this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(this.start, out.asWriter());
        }
    }
}

