/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins;

import com.cloudbees.jenkins.plugins.BitbucketJobProbe;
import jakarta.servlet.http.HttpServletRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class BitbucketPayloadProcessor {
    private final BitbucketJobProbe probe;
    private static final Logger LOGGER = Logger.getLogger(BitbucketPayloadProcessor.class.getName());

    public BitbucketPayloadProcessor(BitbucketJobProbe probe) {
        this.probe = probe;
    }

    public BitbucketPayloadProcessor() {
        this(new BitbucketJobProbe());
    }

    public void processPayload(JSONObject payload, HttpServletRequest request) {
        if ("Bitbucket-Webhooks/2.0".equals(request.getHeader("user-agent"))) {
            if ("repo:push".equals(request.getHeader("x-event-key"))) {
                LOGGER.log(Level.FINER, "Processing new Webhooks payload");
                this.processWebhookPayload(payload);
            }
        } else if (payload.has("actor") && payload.has("repository") && payload.getJSONObject("repository").has("links")) {
            if ("repo:push".equals(request.getHeader("x-event-key"))) {
                LOGGER.log(Level.FINER, "Processing new Cloud Webhooks payload");
                this.processWebhookPayloadBitBucketServer(payload);
            } else if ("repo:refs_changed".equals(request.getHeader("x-event-key"))) {
                LOGGER.log(Level.FINER, "Processing new Self Hosted Server Webhooks payload");
                this.processWebhookPayloadBitBucketSelfHosted(payload);
            } else {
                LOGGER.log(Level.FINER, "Unsupported [x-event-key] value, [x-event-key] is [" + request.getHeader("x-event-key") + "]");
            }
        } else if (payload.has("actor")) {
            LOGGER.log(Level.FINER, "Processing webhook for self-hosted bitbucket instance");
            this.processWebhookPayloadBitBucketSelfHosted(payload);
        } else {
            if ("diagnostics:ping".equals(request.getHeader("x-event-key")) && payload.has("test") && payload.getBoolean("test")) {
                LOGGER.log(Level.FINER, "Bitbucket test connection payload");
                return;
            }
            LOGGER.log(Level.FINER, "Processing old POST service payload");
            this.processPostServicePayload(payload);
        }
    }

    private void processWebhookPayloadBitBucketSelfHosted(JSONObject payload) {
        JSONObject repo;
        if (payload.has("repository")) {
            repo = payload.getJSONObject("repository");
        } else if (payload.has("pullRequest")) {
            repo = payload.getJSONObject("pullRequest").getJSONObject("toRef").getJSONObject("repository");
        } else {
            LOGGER.log(Level.WARNING, "Not possible to trigger job for event '{0}'. Only PR events and pushes are supported for now.", payload.get("eventKey"));
            LOGGER.log(Level.FINE, payload.toString());
            return;
        }
        String user = payload.getJSONObject("actor").getString("name");
        String url = repo.getJSONObject("project").getString("key").toLowerCase() + "/" + repo.getString("slug");
        String scm = "git";
        this.probe.triggerMatchingJobs(user, url, scm, payload.toString());
    }

    private void processWebhookPayload(JSONObject payload) {
        if (this.isPayloadOldMemberNull(payload)) {
            String branchName = this.getBranchName(payload);
            JSONObject repo = payload.getJSONObject("repository");
            LOGGER.log(Level.FINER, "Branch [" + branchName + "] was created");
            String user = this.getUser(payload, "actor");
            String url = repo.getJSONObject("links").getJSONObject("html").getString("href");
            String scm = repo.has("scm") ? repo.getString("scm") : "git";
            this.probe.triggerMatchingJobs(user, url, scm, payload.toString(), branchName);
        } else if (payload.has("repository")) {
            JSONObject repo = payload.getJSONObject("repository");
            LOGGER.log(Level.FINER, "Received commit hook notification for {0}", repo);
            String user = this.getUser(payload, "actor");
            String url = repo.getJSONObject("links").getJSONObject("html").getString("href");
            String scm = repo.has("scm") ? repo.getString("scm") : "git";
            this.probe.triggerMatchingJobs(user, url, scm, payload.toString());
        } else if (payload.has("scm")) {
            LOGGER.log(Level.FINER, "Received commit hook notification for hg: {0}", payload);
            String user = this.getUser(payload, "owner");
            String url = payload.getJSONObject("links").getJSONObject("html").getString("href");
            String scm = payload.has("scm") ? payload.getString("scm") : "hg";
            this.probe.triggerMatchingJobs(user, url, scm, payload.toString());
        }
    }

    private String getBranchName(JSONObject payload) {
        if (payload.has("push")) {
            LOGGER.log(Level.FINER, "found [push] in payload");
            JSONObject jsonObjectPush = payload.getJSONObject("push");
            if (jsonObjectPush.has("changes")) {
                LOGGER.log(Level.FINER, "found [push/changes] in payload");
                JSONArray jsonArrayChanges = jsonObjectPush.getJSONArray("changes");
                for (Object jsonArrayChange : jsonArrayChanges) {
                    JSONObject jsonObjectNew;
                    JSONObject jsonObject = (JSONObject)jsonArrayChange;
                    if (!jsonObject.has("new") || !(jsonObjectNew = jsonObject.getJSONObject("new")).has("name")) continue;
                    return jsonObjectNew.getString("name");
                }
            }
        }
        return "";
    }

    private boolean isPayloadOldMemberNull(JSONObject payload) {
        if (payload.has("push")) {
            LOGGER.log(Level.FINER, "found [push] in payload");
            JSONObject jsonObjectPush = payload.getJSONObject("push");
            if (jsonObjectPush.has("changes")) {
                LOGGER.log(Level.FINER, "found [push/changes] in payload");
                JSONArray jsonArrayChanges = jsonObjectPush.getJSONArray("changes");
                Iterator iterator = jsonArrayChanges.iterator();
                if (iterator.hasNext()) {
                    Object jsonArrayChange = iterator.next();
                    JSONObject jsonObject = (JSONObject)jsonArrayChange;
                    return jsonObject.get("old") instanceof JSONNull;
                }
            }
        }
        return false;
    }

    private String getUser(JSONObject payload, String jsonObject) {
        String user;
        try {
            user = payload.getJSONObject(jsonObject).getString("username");
        }
        catch (JSONException e1) {
            try {
                user = payload.getJSONObject(jsonObject).getString("nickname");
            }
            catch (JSONException e2) {
                user = payload.getJSONObject(jsonObject).getString("display_name");
            }
        }
        return user;
    }

    private void processWebhookPayloadBitBucketServer(JSONObject payload) {
        JSONObject repo = payload.getJSONObject("repository");
        String user = this.getUser(payload, "actor");
        String url = "";
        if (repo.getJSONObject("links").getJSONArray("self").size() != 0) {
            try {
                URL pushHref = new URL(repo.getJSONObject("links").getJSONArray("self").getJSONObject(0).getString("href"));
                url = pushHref.toString().replaceFirst("projects.*", repo.getString("fullName").toLowerCase());
                String scm = repo.has("scmId") ? repo.getString("scmId") : "git";
                this.probe.triggerMatchingJobs(user, url, scm, payload.toString());
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, String.format("URL %s is malformed", url), e);
            }
        }
    }

    private void processPostServicePayload(JSONObject payload) {
        JSONObject repo = payload.getJSONObject("repository");
        LOGGER.log(Level.FINER, "Received commit hook notification for {0}", repo);
        String user = payload.getString("user");
        String url = payload.getString("canon_url") + repo.getString("absolute_url");
        String scm = repo.getString("scm");
        this.probe.triggerMatchingJobs(user, url, scm, payload.toString());
    }
}

