/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins;

import com.cloudbees.jenkins.plugins.BitBucketMultibranchTrigger;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import jenkins.branch.MultiBranchProject;

@Extension
public class BitbucketEnvironmentContributor
extends EnvironmentContributor {
    private static final Logger LOGGER = Logger.getLogger(BitbucketEnvironmentContributor.class.getName());

    public void buildEnvironmentFor(@NonNull Run r, @NonNull EnvVars envs, @NonNull TaskListener listener) throws IOException, InterruptedException {
        super.buildEnvironmentFor(r, envs, listener);
    }

    public void buildEnvironmentFor(@NonNull Job j, @NonNull EnvVars envs, @NonNull TaskListener listener) throws IOException, InterruptedException {
        super.buildEnvironmentFor(j, envs, listener);
        ItemGroup parent = j.getParent();
        AtomicReference<Object> bitBucketMultibranchTrigger = new AtomicReference<Object>(null);
        if (parent instanceof MultiBranchProject) {
            ((MultiBranchProject)parent).getTriggers().forEach((triggerDescriptor, trigger) -> {
                if (trigger instanceof BitBucketMultibranchTrigger) {
                    bitBucketMultibranchTrigger.set(((BitBucketMultibranchTrigger)((Object)trigger)));
                }
            });
        }
        if (bitBucketMultibranchTrigger.get() != null) {
            if (((BitBucketMultibranchTrigger)bitBucketMultibranchTrigger.get()).getPayload() == null) {
                LOGGER.finest("BITBUCKET_PAYLOAD is null, ignoring");
            } else {
                envs.put("BITBUCKET_PAYLOAD", ((BitBucketMultibranchTrigger)bitBucketMultibranchTrigger.get()).getPayload());
            }
        }
    }
}

