/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins;

import com.cloudbees.jenkins.plugins.BitBucketPayload;
import com.cloudbees.jenkins.plugins.BitBucketPushCause;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;

public class BitBucketTriggerRunnable
implements Runnable {
    private final String payload;
    private final Job<?, ?> job;
    private final Logger logger;
    private final String pushBy;
    private final String branchName;
    private final Boolean buildOnCreatedBranch;

    public BitBucketTriggerRunnable(String payload, Job<?, ?> job, Logger logger, String pushBy, String branchName, Boolean buildOnCreatedBranch) {
        this.payload = payload;
        this.job = job;
        this.logger = logger;
        this.pushBy = pushBy;
        this.branchName = branchName;
        this.buildOnCreatedBranch = buildOnCreatedBranch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean runPolling() {
        try (StreamTaskListener listener = new StreamTaskListener(this.getLogFile());){
            PrintStream logger = listener.getLogger();
            long start = System.currentTimeMillis();
            logger.println("Started on " + DateFormat.getDateTimeInstance().format(new Date()));
            SCMTriggerItem scmTriggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem(this.job);
            if (scmTriggerItem == null) {
                boolean bl = false;
                return bl;
            }
            boolean result = scmTriggerItem.poll((TaskListener)listener).hasChanges();
            logger.println("Done. Took " + Util.getTimeSpanString((long)(System.currentTimeMillis() - start)));
            if (this.branchName == null || this.branchName.isEmpty()) {
                if (result) {
                    logger.println("Changes found");
                } else {
                    logger.println("No changes");
                }
            } else {
                if (this.buildOnCreatedBranch.booleanValue()) {
                    logger.println("Branch [" + this.branchName + "] was created");
                    boolean bl = true;
                    return bl;
                }
                logger.println("Branch [" + this.branchName + "] was created but \"Build on branch created\" is false, not triggering");
                boolean bl = false;
                return bl;
            }
            boolean bl = result;
            return bl;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to record SCM polling", e);
            return false;
        }
    }

    @Override
    public void run() {
        if (this.job == null) {
            this.logger.info("job is null");
            return;
        }
        if (this.runPolling()) {
            this.buildJob();
        }
    }

    private void buildJob() {
        BitBucketPushCause cause;
        String name = " #" + this.job.getNextBuildNumber();
        try {
            cause = new BitBucketPushCause(this.getLogFile(), this.pushBy);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Failed to parse the polling log", e);
            cause = new BitBucketPushCause(this.pushBy);
        }
        ParameterizedJobMixIn pJob = new ParameterizedJobMixIn(){

            protected Job asJob() {
                return BitBucketTriggerRunnable.this.job;
            }
        };
        BitBucketPayload bitBucketPayload = new BitBucketPayload(this.payload);
        pJob.scheduleBuild2(5, new Action[]{new CauseAction((Cause)cause), bitBucketPayload});
        if (pJob.scheduleBuild((Cause)cause)) {
            if (this.branchName == null || this.branchName.isEmpty()) {
                this.logger.info("SCM changes detected in [" + this.job.getName() + "]. Triggering [" + name + "]");
            } else if (this.buildOnCreatedBranch.booleanValue()) {
                this.logger.info("Branch [" + this.branchName + "] created. Triggering [" + name + "]");
            } else {
                this.logger.info("Branch [" + this.branchName + "] created. but [Build on branch created] is false, not building");
            }
        } else {
            this.logger.info("SCM changes detected in " + this.job.getName() + ". Job is already in the queue");
        }
    }

    public File getLogFile() {
        if (this.job == null) {
            throw new RuntimeException("job is null");
        }
        return new File(this.job.getRootDir(), "bitbucket-polling.log");
    }
}

