/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins;

import com.cloudbees.jenkins.plugins.BitbucketCrumbExclusion;
import com.cloudbees.jenkins.plugins.BitbucketPayloadProcessor;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class BitbucketHookReceiver
extends BitbucketCrumbExclusion
implements UnprotectedRootAction {
    private final BitbucketPayloadProcessor payloadProcessor = new BitbucketPayloadProcessor();
    public static final String BITBUCKET_HOOK_URL = "bitbucket-hook";
    private static final Logger LOGGER = Logger.getLogger(BitbucketHookReceiver.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return BITBUCKET_HOOK_URL;
    }

    public void doIndex(StaplerRequest2 req) throws IOException {
        String body = IOUtils.toString((InputStream)req.getInputStream());
        if (!body.isEmpty() && req.getRequestURI().contains("/bitbucket-hook/")) {
            String contentType = req.getContentType();
            if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
                body = URLDecoder.decode(body);
            }
            if (body.startsWith("payload=")) {
                body = body.substring(8);
            }
            LOGGER.log(Level.FINE, "Received commit hook notification : {0}", body);
            JSONObject payload = JSONObject.fromObject((Object)body);
            this.payloadProcessor.processPayload(payload, (HttpServletRequest)req);
        } else {
            LOGGER.log(Level.WARNING, "The Jenkins job cannot be triggered. You might not have configured correctly the WebHook on BitBucket with the last slash `http://<JENKINS-URL>/bitbucket-hook/` or a 'Test connection' invocation of the hook was triggered.");
        }
    }
}

