/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins;

import com.cloudbees.jenkins.plugins.BitBucketMultibranchTrigger;
import com.cloudbees.jenkins.plugins.BitBucketPushCause;
import com.cloudbees.jenkins.plugins.BitBucketTrigger;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.google.common.base.Objects;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.MercurialSCMSource;
import hudson.scm.SCM;
import hudson.security.ACL;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class BitbucketJobProbe {
    private boolean isBranchPluginAvailable = false;
    private static final Logger LOGGER = Logger.getLogger(BitbucketJobProbe.class.getName());

    public BitbucketJobProbe() {
        if (Jenkins.get().getPlugin("cloudbees-bitbucket-branch-source") != null) {
            LOGGER.log(Level.FINEST, "Bitbucket branch source available");
            this.isBranchPluginAvailable = true;
        }
    }

    public void triggerMatchingJobs(String user, String url, String scm, String payload) {
        this.triggerMatchingJobs(user, url, scm, payload, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerMatchingJobs(String user, String url, String scm, String payload, String branchName) {
        if ("git".equals(scm) || "hg".equals(scm)) {
            Jenkins.getInstance().getACL();
            SecurityContext old = ACL.impersonate2((Authentication)ACL.SYSTEM2);
            try {
                URIish remote = new URIish(url);
                for (Job job : Jenkins.getInstance().getAllItems(Job.class)) {
                    Object trigger22;
                    BitBucketTrigger bTrigger = null;
                    LOGGER.log(Level.FINE, "Considering candidate job [{0}]", job.getName());
                    if (job instanceof ParameterizedJobMixIn.ParameterizedJob) {
                        ParameterizedJobMixIn.ParameterizedJob pJob = (ParameterizedJobMixIn.ParameterizedJob)job;
                        for (Object trigger22 : pJob.getTriggers().values()) {
                            if (trigger22 instanceof BitBucketTrigger) {
                                bTrigger = (BitBucketTrigger)((Object)trigger22);
                                LOGGER.log(Level.FINE, "Job [{0}] has BitBucketTrigger", job.getName());
                                break;
                            }
                            if (!(trigger22 instanceof BitBucketMultibranchTrigger)) continue;
                            LOGGER.fine("Trigger is BitBucketMultibranchTrigger");
                        }
                    } else {
                        LOGGER.finest("job [" + job.getName() + "] is not ParameterizedJobMixIn.ParameterizedJob. [" + job.getClass().getSimpleName() + "]");
                    }
                    if (bTrigger == null) {
                        LOGGER.log(Level.FINE, "[{0}] hasn't BitBucketTrigger set", job.getName());
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Considering to poke {0}", job.getFullDisplayName());
                    SCMTriggerItem item = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)job);
                    if (item == null) {
                        LOGGER.log(Level.FINER, "item is null");
                        continue;
                    }
                    ArrayList<SCM> scmTriggered = new ArrayList<SCM>();
                    if (item.getSCMs().isEmpty()) {
                        LOGGER.log(Level.FINE, "No SCM configuration was found!");
                    }
                    trigger22 = item.getSCMs().iterator();
                    while (trigger22.hasNext()) {
                        SCM scmTrigger = (SCM)trigger22.next();
                        if (this.match(scmTrigger, remote, bTrigger.getOverrideUrl()) && !this.hasBeenTriggered(scmTriggered, scmTrigger)) {
                            LOGGER.log(Level.FINER, "Triggering BitBucket job {0}", job.getFullDisplayName());
                            scmTriggered.add(scmTrigger);
                            bTrigger.onPost(user, payload, branchName);
                            continue;
                        }
                        LOGGER.log(Level.FINEST, String.format("[%s] SCM doesn't match remote repo [%s]", job.getName(), remote));
                    }
                }
                LOGGER.log(Level.FINE, "Now checking SCMSourceOwners/multiBranchProjects");
                for (SCMSourceOwner scmSourceOwner : Jenkins.getInstance().getAllItems(SCMSourceOwner.class)) {
                    LOGGER.log(Level.FINE, "Considering candidate scmSourceOwner {0}", scmSourceOwner.getFullDisplayName());
                    List scmSources = scmSourceOwner.getSCMSources();
                    for (SCMSource scmSource : scmSources) {
                        WorkflowMultiBranchProject workflowMultiBranchProject;
                        LOGGER.log(Level.FINER, "Considering candidate scmSource {0}", scmSource);
                        if (this.match(scmSource, remote)) {
                            if (scmSourceOwner instanceof WorkflowMultiBranchProject) {
                                LOGGER.finest("scmSourceOwner [" + scmSourceOwner.getName() + "] is of type WorkflowMultiBranchProject");
                                workflowMultiBranchProject = (WorkflowMultiBranchProject)scmSourceOwner;
                                AtomicReference<Object> bitBucketMultibranchTrigger = new AtomicReference<Object>(null);
                                if (workflowMultiBranchProject.getTriggers().isEmpty()) {
                                    LOGGER.finest("No triggers found");
                                } else {
                                    workflowMultiBranchProject.getTriggers().forEach((triggerDescriptor, trigger) -> {
                                        if (trigger instanceof BitBucketMultibranchTrigger) {
                                            LOGGER.finest("Found BitBucketMultibranchTrigger type");
                                            bitBucketMultibranchTrigger.set(((BitBucketMultibranchTrigger)((Object)trigger)));
                                        }
                                    });
                                }
                                if (bitBucketMultibranchTrigger.get() == null) {
                                    scmSourceOwner.onSCMSourceUpdated(scmSource);
                                    continue;
                                }
                                if (workflowMultiBranchProject.isBuildable()) {
                                    ((BitBucketMultibranchTrigger)bitBucketMultibranchTrigger.get()).setPayload(payload);
                                    BitBucketPushCause bitBucketPushCause = new BitBucketPushCause(user);
                                    workflowMultiBranchProject.scheduleBuild2(0, new Action[]{new CauseAction((Cause)bitBucketPushCause)});
                                    continue;
                                }
                                LOGGER.finest("workflowMultiBranchProject is not builtable");
                                continue;
                            }
                            scmSourceOwner.onSCMSourceUpdated(scmSource);
                            continue;
                        }
                        if (scmSourceOwner instanceof WorkflowMultiBranchProject) {
                            LOGGER.finest("scmSourceOwner [" + scmSourceOwner.getName() + "] is of type WorkflowMultiBranchProject");
                            workflowMultiBranchProject = (WorkflowMultiBranchProject)scmSourceOwner;
                            if (workflowMultiBranchProject.getTriggers().isEmpty()) {
                                LOGGER.finest("No triggers found");
                                continue;
                            }
                            workflowMultiBranchProject.getTriggers().forEach((triggerDescriptor, trigger) -> {
                                if (trigger instanceof BitBucketMultibranchTrigger) {
                                    LOGGER.finest("Found BitBucketMultibranchTrigger type");
                                    BitBucketMultibranchTrigger bitBucketMultibranchTrigger = (BitBucketMultibranchTrigger)((Object)trigger);
                                    if (bitBucketMultibranchTrigger.getOverrideUrl() == null || bitBucketMultibranchTrigger.getOverrideUrl().isEmpty()) {
                                        LOGGER.finest("Ignoring empty overrideUrl");
                                    } else {
                                        LOGGER.fine("Found override URL [" + bitBucketMultibranchTrigger.getOverrideUrl() + "]");
                                        LOGGER.log(Level.FINE, "Trying to match {0} ", String.valueOf(remote) + "<-->" + bitBucketMultibranchTrigger.getOverrideUrl());
                                        if (bitBucketMultibranchTrigger.getOverrideUrl().equalsIgnoreCase(remote.toString())) {
                                            LOGGER.info(String.format("Triggering BitBucket scmSourceOwner [%s] by overrideUrl [%s]", scmSourceOwner.getName(), bitBucketMultibranchTrigger.getOverrideUrl()));
                                            scmSourceOwner.onSCMSourceUpdated(scmSource);
                                        }
                                    }
                                } else {
                                    LOGGER.finest("Found BitBucketMultibranchTrigger type");
                                }
                            });
                            continue;
                        }
                        LOGGER.log(Level.FINE, String.format("SCM [%s] doesn't match remote repo [%s]", scmSourceOwner.getFullDisplayName(), remote));
                    }
                }
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.WARNING, "Invalid repository URL {0}", url);
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)old);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported SCM type " + scm);
        }
    }

    private boolean hasBeenTriggered(List<SCM> scmTriggered, SCM scmTrigger) {
        for (SCM scm : scmTriggered) {
            if (!scm.equals(scmTrigger)) continue;
            return true;
        }
        return false;
    }

    private boolean match(SCM scm, URIish url, String overrideUrl) {
        if (scm instanceof GitSCM) {
            LOGGER.log(Level.FINE, "SCM is instance of GitSCM");
            for (RemoteConfig remoteConfig : ((GitSCM)scm).getRepositories()) {
                for (URIish urIish : remoteConfig.getURIs()) {
                    if (urIish.getPath().startsWith("/scm")) {
                        urIish = urIish.setPath(urIish.getPath().substring(4));
                    }
                    if (StringUtils.isEmpty((String)url.getHost())) {
                        urIish = urIish.setHost(url.getHost());
                    }
                    LOGGER.log(Level.FINE, "Trying to match {0} ", urIish.toString() + "<-->" + String.valueOf(url));
                    if (GitStatus.looselyMatches((URIish)urIish, (URIish)url)) {
                        return true;
                    }
                    if (overrideUrl == null || overrideUrl.isEmpty()) continue;
                    LOGGER.log(Level.FINE, "Trying to match using override Repository URL {0} ", overrideUrl + "<-->" + String.valueOf(url));
                    return overrideUrl.contentEquals(url.toString());
                }
            }
        } else if (scm instanceof MercurialSCM) {
            LOGGER.log(Level.FINEST, "SCM is instance of MercurialSCM");
            try {
                URI hgUri = new URI(((MercurialSCM)scm).getSource());
                String remote = url.toString();
                if (this.looselyMatches(hgUri, remote)) {
                    return true;
                }
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.SEVERE, "Could not parse jobSource uri: {0} ", ex);
            }
        } else {
            LOGGER.log(Level.FINEST, "SCM is instance of [" + scm.getClass().getSimpleName() + "] which is not supported");
        }
        return false;
    }

    private boolean match(SCMSource scm, URIish url) {
        if (scm instanceof GitSCMSource || this.isBranchPluginAvailable && scm instanceof BitbucketSCMSource) {
            URIish urIish;
            Object gitRemote;
            if (scm instanceof GitSCMSource) {
                LOGGER.log(Level.FINEST, "SCMSource is GitSCMSource");
                gitRemote = ((GitSCMSource)scm).getRemote();
            } else if (this.isBranchPluginAvailable) {
                LOGGER.log(Level.FINEST, "SCMSource is BitbucketSCMSource");
                gitRemote = ((BitbucketSCMSource)scm).getServerUrl() + "/" + ((BitbucketSCMSource)scm).getRepoOwner() + "/" + ((BitbucketSCMSource)scm).getRepository();
            } else {
                return false;
            }
            LOGGER.log(Level.FINEST, "SCMSource remote is " + (String)gitRemote);
            try {
                urIish = new URIish((String)gitRemote);
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.SEVERE, "Could not parse gitRemote: " + (String)gitRemote, e);
                return false;
            }
            if (urIish.getPath().startsWith("/scm")) {
                urIish = urIish.setPath(urIish.getPath().substring(4));
            }
            if (StringUtils.isEmpty((String)url.getHost())) {
                urIish = urIish.setHost(url.getHost());
            }
            LOGGER.log(Level.FINE, "Trying to match {0} ", urIish.toString() + "<-->" + String.valueOf(url));
            return GitStatus.looselyMatches((URIish)urIish, (URIish)url);
        }
        if (scm instanceof MercurialSCMSource) {
            LOGGER.log(Level.FINEST, "SCMSource is MercurialSCMSource");
            try {
                URI hgUri = new URI(((MercurialSCMSource)scm).getSource());
                String remote = url.toString();
                if (this.looselyMatches(hgUri, remote)) {
                    return true;
                }
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.SEVERE, "Could not parse jobSource uri: {0} ", ex);
            }
        } else {
            LOGGER.log(Level.FINEST, "SCMSource is [" + scm.getClass().getSimpleName() + "] which is not supported");
        }
        return false;
    }

    private boolean looselyMatches(URI notifyUri, String repository) {
        boolean result = false;
        try {
            URI repositoryUri = new URI(repository);
            result = Objects.equal((Object)notifyUri.getHost(), (Object)repositoryUri.getHost()) && Objects.equal((Object)notifyUri.getPath(), (Object)repositoryUri.getPath()) && Objects.equal((Object)notifyUri.getQuery(), (Object)repositoryUri.getQuery());
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.SEVERE, "Could not parse repository uri: {0}, {1}", new Object[]{repository, ex});
        }
        return result;
    }
}

