/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch.buildstrategies.basic;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.branch.buildstrategies.basic.Messages;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class AnyBranchBuildStrategyImpl
extends BranchBuildStrategy {
    @NonNull
    private final List<BranchBuildStrategy> strategies;

    @DataBoundConstructor
    public AnyBranchBuildStrategyImpl(List<BranchBuildStrategy> strategies) {
        this.strategies = new ArrayList<BranchBuildStrategy>(Util.fixNull(strategies));
    }

    @Deprecated
    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, @CheckForNull SCMRevision prevRevision) {
        return this.isAutomaticBuild(source, head, currRevision, prevRevision, (TaskListener)new LogTaskListener(Logger.getLogger(((Object)((Object)this)).getClass().getName()), Level.INFO));
    }

    @Deprecated
    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, @CheckForNull SCMRevision prevRevision, @NonNull TaskListener taskListener) {
        return this.isAutomaticBuild(source, head, currRevision, prevRevision, prevRevision, taskListener);
    }

    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, @CheckForNull SCMRevision lastBuiltRevision, @CheckForNull SCMRevision lastSeenRevision, @NonNull TaskListener taskListener) {
        if (this.strategies.isEmpty()) {
            return false;
        }
        for (BranchBuildStrategy strategy : this.strategies) {
            if (!strategy.automaticBuild(source, head, currRevision, lastBuiltRevision, lastSeenRevision, taskListener)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public List<BranchBuildStrategy> getStrategies() {
        return Collections.unmodifiableList(this.strategies);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AnyBranchBuildStrategyImpl that = (AnyBranchBuildStrategyImpl)((Object)o);
        return this.strategies.equals(that.strategies);
    }

    public int hashCode() {
        return this.strategies.hashCode();
    }

    public String toString() {
        return "AnyBranchBuildStrategyImpl{strategies=" + String.valueOf(this.strategies) + "}";
    }

    @Symbol(value={"buildAnyBranches"})
    @Extension
    public static class DescriptorImpl
    extends BranchBuildStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.AnyBranchBuildStrategyImpl_displayName();
        }
    }
}

