/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch.buildstrategies.basic;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.branch.buildstrategies.basic.Messages;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.mixin.ChangeRequestSCMRevision;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.ProtectedExternally;
import org.kohsuke.stapler.DataBoundConstructor;

public class ChangeRequestBuildStrategyImpl
extends BranchBuildStrategy {
    private static final Logger LOGGER = Logger.getLogger(ChangeRequestBuildStrategyImpl.class.getName());
    private final boolean ignoreTargetOnlyChanges;
    private final boolean ignoreUntrustedChanges;

    @Deprecated
    public ChangeRequestBuildStrategyImpl(boolean ignoreTargetOnlyChanges) {
        this(ignoreTargetOnlyChanges, false);
    }

    @DataBoundConstructor
    public ChangeRequestBuildStrategyImpl(boolean ignoreTargetOnlyChanges, boolean ignoreUntrustedChanges) {
        this.ignoreTargetOnlyChanges = ignoreTargetOnlyChanges;
        this.ignoreUntrustedChanges = ignoreUntrustedChanges;
    }

    public boolean isIgnoreTargetOnlyChanges() {
        return this.ignoreTargetOnlyChanges;
    }

    public boolean isIgnoreUntrustedChanges() {
        return this.ignoreUntrustedChanges;
    }

    @Deprecated
    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, @CheckForNull SCMRevision prevRevision) {
        return this.isAutomaticBuild(source, head, currRevision, prevRevision, (TaskListener)new LogTaskListener(Logger.getLogger(((Object)((Object)this)).getClass().getName()), Level.INFO));
    }

    @Restricted(value={ProtectedExternally.class})
    @Deprecated
    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, @CheckForNull SCMRevision prevRevision, @NonNull TaskListener taskListener) {
        return this.isAutomaticBuild(source, head, currRevision, prevRevision, prevRevision, taskListener);
    }

    @Restricted(value={ProtectedExternally.class})
    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, @CheckForNull SCMRevision lastBuiltRevision, @CheckForNull SCMRevision lastSeenRevision, @NonNull TaskListener listener) {
        if (!(head instanceof ChangeRequestSCMHead)) {
            return false;
        }
        if (this.ignoreTargetOnlyChanges && currRevision instanceof ChangeRequestSCMRevision) {
            ChangeRequestSCMRevision curr = (ChangeRequestSCMRevision)currRevision;
            if (lastBuiltRevision instanceof ChangeRequestSCMRevision) {
                ChangeRequestSCMRevision revision = (ChangeRequestSCMRevision)lastBuiltRevision;
                if (curr.isMerge() && curr.equivalent(revision)) {
                    return false;
                }
            }
        }
        try {
            if (this.ignoreUntrustedChanges && !currRevision.equals((Object)source.getTrustedRevision(currRevision, listener))) {
                return false;
            }
        }
        catch (IOException | InterruptedException e) {
            LogRecord lr = new LogRecord(Level.WARNING, "Could not determine trust status for revision {0} of {1}, assuming untrusted");
            lr.setParameters(new Object[]{currRevision, head});
            lr.setThrown(e);
            Functions.printLogRecord((LogRecord)lr);
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ChangeRequestBuildStrategyImpl that = (ChangeRequestBuildStrategyImpl)((Object)o);
        return this.ignoreUntrustedChanges == that.ignoreUntrustedChanges && this.ignoreTargetOnlyChanges == that.ignoreTargetOnlyChanges;
    }

    public int hashCode() {
        return (this.ignoreTargetOnlyChanges ? 1 : 0) + (this.ignoreUntrustedChanges ? 2 : 0);
    }

    public String toString() {
        return "ChangeRequestBuildStrategyImpl{ignoreTargetOnlyChanges=" + this.ignoreTargetOnlyChanges + "ignoreUntrustedChanges=" + this.ignoreUntrustedChanges + "}";
    }

    @Symbol(value={"buildChangeRequests"})
    @Extension
    public static class DescriptorImpl
    extends BranchBuildStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ChangeRequestBuildStrategyImpl_displayName();
        }
    }
}

