/*
 * Decompiled with CFR 0.152.
 */
package com.jenkinsci.plugins.badge.action;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import io.jenkins.plugins.emoji.symbols.Emojis;
import io.jenkins.plugins.ionicons.Ionicons;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public abstract class AbstractBadgeAction
implements Action,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AbstractBadgeAction.class.getName());
    private final String id;
    private String icon;
    private String text;
    private String cssClass;
    private String style;
    private String link;
    private String target;

    @Deprecated(since="2.8", forRemoval=true)
    protected AbstractBadgeAction(String id, String icon, String text, String cssClass, String style, String link) {
        this(id, icon, text, cssClass, style, link, null);
    }

    protected AbstractBadgeAction(String id, String icon, String text, String cssClass, String style, String link, String target) {
        this.id = id != null ? id : UUID.randomUUID().toString();
        this.icon = icon;
        this.text = text;
        this.cssClass = cssClass;
        this.style = style;
        this.link = link;
        this.target = target;
    }

    @Exported
    @Whitelisted
    @NonNull
    public String getId() {
        return this.id;
    }

    @Whitelisted
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Exported
    @Whitelisted
    public String getIcon() {
        if (this.icon == null || this.icon.isBlank() || this.icon.startsWith("/") || this.icon.startsWith("symbol-") || this.icon.startsWith("icon-") || this.icon.matches("^https?://.*")) {
            return this.icon;
        }
        return switch (this.icon) {
            case "completed.gif" -> "symbol-status-blue";
            case "db_in.gif" -> Ionicons.getIconClassName((String)"cloud-upload-outline");
            case "db_out.gif" -> Ionicons.getIconClassName((String)"cloud-download-outline");
            case "delete.gif" -> "symbol-trash";
            case "error.gif" -> "symbol-status-red";
            case "folder.gif" -> "symbol-folder";
            case "green.gif" -> Emojis.getIconClassName((String)"green_square");
            case "info.gif" -> "symbol-information-circle";
            case "red.gif" -> Emojis.getIconClassName((String)"red_square");
            case "save.gif" -> Ionicons.getIconClassName((String)"save-outline");
            case "success.gif" -> "symbol-status-blue";
            case "text.gif" -> "symbol-document-text";
            case "warning.gif" -> "symbol-status-yellow";
            case "yellow.gif" -> Emojis.getIconClassName((String)"yellow_square");
            default -> Jenkins.RESOURCE_PATH + "/images/16x16/" + this.icon;
        };
    }

    @Whitelisted
    public void setText(String text) {
        this.text = text;
    }

    @Exported
    @Whitelisted
    public String getText() {
        if (this.text == null || this.text.isBlank()) {
            return this.text;
        }
        try {
            return Jenkins.get().getMarkupFormatter().translate(this.text);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Error preparing badge text for UI", ex);
            return "<b><font color=\"var(--error-color)\">Error preparing badge text for UI</font></b>";
        }
    }

    @Whitelisted
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Exported
    @Whitelisted
    public String getCssClass() {
        return this.cssClass;
    }

    @Whitelisted
    public void setStyle(String style) {
        this.style = style;
    }

    @Exported
    @Whitelisted
    public String getStyle() {
        return this.style;
    }

    @Whitelisted
    public void setLink(String link) {
        this.link = link;
    }

    @Exported
    @Whitelisted
    public String getLink() {
        if (this.link == null || this.link.isBlank() || this.link.startsWith("/") || this.link.matches("^https?://.*") || this.link.matches("^mailto:.*")) {
            return this.link;
        }
        LOGGER.log(Level.WARNING, () -> "Invalid link value: '" + this.link + "' - ignoring it");
        return null;
    }

    @Whitelisted
    public void setTarget(String target) {
        this.target = target;
    }

    @Exported
    @Whitelisted
    public String getTarget() {
        return this.target;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "";
    }
}

