/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azurekeyvaultplugin.credentials.certificate;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureCredentialsProvider;
import org.jvnet.localizer.ResourceBundleHolder;

public class AzureCertificateCredentials
extends BaseStandardCredentials
implements StandardCertificateCredentials {
    private static final Logger LOG = Logger.getLogger(AzureCertificateCredentials.class.getName());
    private final Supplier<Secret> keyStoreSource;
    private final Supplier<Secret> password;

    public AzureCertificateCredentials(CredentialsScope scope, String id, String description, Supplier<Secret> password, Supplier<Secret> keyStoreSource) {
        super(scope, id, description);
        Objects.requireNonNull(keyStoreSource);
        this.password = password;
        this.keyStoreSource = keyStoreSource;
    }

    @CheckForNull
    private static char[] toCharArray(@NonNull Secret password) {
        String plainText = Util.fixEmpty((String)password.getPlainText());
        return plainText == null ? null : plainText.toCharArray();
    }

    @NonNull
    public KeyStore getKeyStore() {
        ByteArrayInputStream keyStoreByteInputStream;
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("PKCS12 is a keystore type per the JLS spec", e);
        }
        try {
            keyStoreByteInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(Secret.toString((Secret)this.keyStoreSource.get())));
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.WARNING, "Error decoding Keystore. A base64 encoded certificate is expected. Secret ID:" + this.getId() + ". " + e.getMessage(), e);
            throw new IllegalStateException("Cannot decode keystore", e);
        }
        try {
            keyStore.load(keyStoreByteInputStream, AzureCertificateCredentials.toCharArray(this.getPassword()));
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            LOG.log(Level.WARNING, "Error loading Keystore . Secret ID:" + this.getId() + ". " + e.getMessage(), e);
            throw new IllegalStateException("Error loading Keystore.", e);
        }
        return keyStore;
    }

    @NonNull
    public Secret getKeyStoreSecret() {
        return this.keyStoreSource.get();
    }

    @NonNull
    public Secret getPassword() {
        return this.password.get();
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return ResourceBundleHolder.get(Messages.class).format("CertificateCredentialsImpl.DisplayName", new Object[0]);
        }

        public String getIconClassName() {
            return "icon-application-certificate";
        }

        public boolean isApplicable(CredentialsProvider provider) {
            return provider instanceof AzureCredentialsProvider;
        }
    }
}

