/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azurekeyvaultplugin.credentials.usernamepassword;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.Secret;
import java.util.function.Supplier;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureCredentialsProvider;
import org.jvnet.localizer.ResourceBundleHolder;

public class AzureUsernamePasswordCredentials
extends BaseStandardCredentials
implements StandardUsernamePasswordCredentials {
    private final Supplier<Secret> password;
    private final String username;

    public AzureUsernamePasswordCredentials(CredentialsScope scope, String id, String username, String description, Supplier<Secret> password) {
        super(scope, id, description);
        this.password = password;
        this.username = Util.fixNull((String)username);
    }

    @NonNull
    public Secret getPassword() {
        return this.password.get();
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Extension(ordinal=1.0)
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return ResourceBundleHolder.get(Messages.class).format("UsernamePasswordCredentialsImpl.DisplayName", new Object[0]);
        }

        public String getIconClassName() {
            return "symbol-id-card";
        }

        public boolean isApplicable(CredentialsProvider provider) {
            return provider instanceof AzureCredentialsProvider;
        }
    }
}

