/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azurekeyvaultplugin;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.security.Permission;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconType;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureCredentialsProvider;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.core.Authentication;

public class AzureCredentialsStore
extends CredentialsStore {
    private final AzureCredentialsProvider provider;
    private final AzureCredentialsStoreAction action = new AzureCredentialsStoreAction(this);

    public AzureCredentialsStore(AzureCredentialsProvider provider) {
        super(AzureCredentialsProvider.class);
        this.provider = provider;
    }

    @NonNull
    public ModelObject getContext() {
        return Jenkins.get();
    }

    public boolean hasPermission2(@NonNull Authentication authentication, @NonNull Permission permission) {
        return CredentialsProvider.VIEW.equals((Object)permission) && Jenkins.get().getACL().hasPermission2(authentication, permission);
    }

    @NonNull
    public List<Credentials> getCredentials(@NonNull Domain domain) {
        if (Domain.global().equals((Object)domain) && Jenkins.get().hasPermission(CredentialsProvider.VIEW)) {
            return this.provider.getCredentialsInItemGroup(Credentials.class, (ItemGroup)Jenkins.get(), ACL.SYSTEM2, Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) {
        throw new UnsupportedOperationException("Jenkins may not add credentials to Azure Key Vault");
    }

    public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) {
        throw new UnsupportedOperationException("Jenkins may not remove credentials in Azure Key Vault");
    }

    public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials credentials, @NonNull Credentials credentials1) {
        throw new UnsupportedOperationException("Jenkins may not update credentials in Azure Key Vault");
    }

    @Nullable
    public CredentialsStoreAction getStoreAction() {
        return this.action;
    }

    @ExportedBean
    public static final class AzureCredentialsStoreAction
    extends CredentialsStoreAction {
        private static final String ICON_CLASS = "icon-azure-key-vault-credentials-store";
        private final AzureCredentialsStore store;

        private AzureCredentialsStoreAction(AzureCredentialsStore store) {
            this.store = store;
            this.addIcons();
        }

        private void addIcons() {
            IconSet.icons.addIcon(new Icon("icon-azure-key-vault-credentials-store icon-sm", "azure-keyvault/images/16x16/icon.png", "width: 16px; height: 16px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-azure-key-vault-credentials-store icon-md", "azure-keyvault/images/24x24/icon.png", "width: 24px; height: 24px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-azure-key-vault-credentials-store icon-lg", "azure-keyvault/images/32x32/icon.png", "width: 32px; height: 32px;", IconType.PLUGIN));
            IconSet.icons.addIcon(new Icon("icon-azure-key-vault-credentials-store icon-xlg", "azure-keyvault/images/48x48/icon.png", "width: 48px; height: 48px;", IconType.PLUGIN));
        }

        @NonNull
        public CredentialsStore getStore() {
            return this.store;
        }

        public String getIconFileName() {
            return this.isVisible() ? "/plugin/azure-keyvault/images/32x32/icon.png" : null;
        }

        public String getIconClassName() {
            return this.isVisible() ? ICON_CLASS : null;
        }

        public String getDisplayName() {
            return "Azure Key Vault";
        }
    }
}

