/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azurekeyvaultplugin;

import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import com.microsoft.jenkins.keyvault.SecretClientCache;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.util.Secret;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureCredentialsStore;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultException;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultGlobalConfiguration;
import org.jenkinsci.plugins.azurekeyvaultplugin.credentials.certificate.AzureCertificateCredentials;
import org.jenkinsci.plugins.azurekeyvaultplugin.credentials.secretfile.AzureSecretFileCredentials;
import org.jenkinsci.plugins.azurekeyvaultplugin.credentials.sshuserprivatekey.AzureSSHUserPrivateKeyCredentials;
import org.jenkinsci.plugins.azurekeyvaultplugin.credentials.string.AzureSecretStringCredentials;
import org.jenkinsci.plugins.azurekeyvaultplugin.credentials.usernamepassword.AzureUsernamePasswordCredentials;
import org.springframework.security.core.Authentication;

@Extension
public class AzureCredentialsProvider
extends CredentialsProvider {
    private static final Logger LOG = Logger.getLogger(AzureCredentialsProvider.class.getName());
    private static final String CACHE_KEY = "key";
    private static final String DEFAULT_TYPE = "string";
    private static final String DEFAULT_SCOPE = "GLOBAL";
    private final AzureCredentialsStore store = new AzureCredentialsStore(this);
    private final LoadingCache<String, Collection<IdCredentials>> cache = Caffeine.newBuilder().maximumSize(1L).expireAfterWrite(Duration.ofMinutes(120L)).refreshAfterWrite(Duration.ofMinutes(10L)).build(key -> AzureCredentialsProvider.fetchCredentials());

    public void refreshCredentials() {
        this.cache.invalidateAll();
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentialsInItemGroup(@NonNull Class<C> aClass, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        if (ACL.SYSTEM2.equals((Object)authentication)) {
            ArrayList<Credentials> list = new ArrayList<Credentials>();
            try {
                Collection credentials = (Collection)this.cache.get((Object)CACHE_KEY);
                if (credentials == null) {
                    throw new IllegalStateException("Cache is not working");
                }
                for (IdCredentials credential : credentials) {
                    if (!aClass.isAssignableFrom(credential.getClass())) continue;
                    if (CredentialsScope.SYSTEM == credential.getScope() && !(itemGroup instanceof Jenkins)) {
                        LOG.log(Level.FINEST, "getCredentials {0} has SYSTEM scope but the context is not Jenkins. Ignoring credential", credential.getId());
                        continue;
                    }
                    if (aClass.isAssignableFrom(credential.getClass())) {
                        list.add((Credentials)aClass.cast(credential));
                        continue;
                    }
                    LOG.log(Level.FINEST, "getCredentials {0} does not match", credential.getId());
                }
            }
            catch (RuntimeException e) {
                LOG.log(Level.WARNING, "Error retrieving secrets from Azure KeyVault: " + e.getMessage(), e);
                return Collections.emptyList();
            }
            return list;
        }
        return Collections.emptyList();
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentialsInItem(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        Objects.requireNonNull(item);
        return this.getCredentialsInItemGroup(type, null, authentication, domainRequirements);
    }

    @VisibleForTesting
    static String getSecretName(String itemId) {
        if (StringUtils.isEmpty((CharSequence)itemId)) {
            throw new AzureKeyVaultException("Empty id for key vault item.");
        }
        int index = itemId.lastIndexOf(47);
        if (index < 0) {
            throw new AzureKeyVaultException("Wrong pattern for key vault item id.");
        }
        return itemId.substring(index + 1);
    }

    private static String getKeyVaultURL(AzureKeyVaultGlobalConfiguration azureKeyVaultGlobalConfiguration) {
        String credentialID = azureKeyVaultGlobalConfiguration.getCredentialID();
        Object keyVaultURL = azureKeyVaultGlobalConfiguration.getKeyVaultURL();
        if (StringUtils.isEmpty((CharSequence)keyVaultURL) || StringUtils.isEmpty((CharSequence)credentialID)) {
            return null;
        }
        if (!((String)keyVaultURL).endsWith("/")) {
            keyVaultURL = (String)keyVaultURL + "/";
        }
        return keyVaultURL;
    }

    private static List<IdCredentials> fetchCredentials() {
        AzureKeyVaultGlobalConfiguration azureKeyVaultGlobalConfiguration = (AzureKeyVaultGlobalConfiguration)((Object)GlobalConfiguration.all().get(AzureKeyVaultGlobalConfiguration.class));
        if (azureKeyVaultGlobalConfiguration == null) {
            throw new AzureKeyVaultException("No global key vault url configured.");
        }
        String credentialID = azureKeyVaultGlobalConfiguration.getCredentialID();
        try {
            String keyVaultURL = AzureCredentialsProvider.getKeyVaultURL(azureKeyVaultGlobalConfiguration);
            SecretClient client = SecretClientCache.get((String)credentialID, (String)keyVaultURL);
            String configuredLabelSelector = AzureCredentialsProvider.extractLabelSelector();
            ArrayList<IdCredentials> credentials = new ArrayList<IdCredentials>();
            for (SecretProperties secretItem : client.listPropertiesOfSecrets()) {
                IdCredentials cred = AzureCredentialsProvider.mapPropertiesToCredentials(secretItem, configuredLabelSelector, client, keyVaultURL);
                if (cred == null) continue;
                credentials.add(cred);
            }
            return credentials;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error retrieving secrets from Azure KeyVault: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    private static IdCredentials mapPropertiesToCredentials(SecretProperties secretItem, String configuredLabelSelector, SecretClient client, String keyVaultURL) {
        String id = secretItem.getId();
        try {
            HashMap tags = secretItem.getTags();
            if (tags == null) {
                tags = new HashMap();
            }
            if (StringUtils.isNotBlank((CharSequence)configuredLabelSelector)) {
                String secretLabelSelector = tags.getOrDefault("jenkins-label", "");
                List<String> secretLabels = Arrays.asList(secretLabelSelector.split(","));
                List<String> configuredLabels = Arrays.asList(configuredLabelSelector.split(","));
                if (secretLabels.stream().filter(configuredLabels::contains).findAny().isEmpty()) {
                    return null;
                }
            }
            String type = tags.getOrDefault("type", DEFAULT_TYPE);
            String jenkinsID = tags.getOrDefault("jenkinsID", AzureCredentialsProvider.getSecretName(id));
            String description = tags.getOrDefault("description", "");
            String labelScope = tags.getOrDefault("scope", DEFAULT_SCOPE).toUpperCase();
            CredentialsScope scope = CredentialsScope.GLOBAL;
            if (tags.containsKey("scope") && labelScope.equalsIgnoreCase("SYSTEM")) {
                scope = CredentialsScope.SYSTEM;
            }
            if (tags.containsKey("username") && type.equals(DEFAULT_TYPE)) {
                type = "username";
            }
            switch (type) {
                case "string": {
                    return new AzureSecretStringCredentials(scope, jenkinsID, description, new KeyVaultSecretRetriever(client, id));
                }
                case "secretFile": {
                    Object fileName = (String)tags.get("fileName");
                    if (((String)fileName).isEmpty()) {
                        fileName = AzureCredentialsProvider.getSecretName(id) + ".txt";
                    }
                    return new AzureSecretFileCredentials(scope, jenkinsID, description, (String)fileName, new KeyVaultSecretRetriever(client, id));
                }
                case "username": {
                    return new AzureUsernamePasswordCredentials(scope, jenkinsID, (String)tags.get("username"), description, new KeyVaultSecretRetriever(client, id));
                }
                case "sshUserPrivateKey": {
                    String usernameSecretTag = (String)tags.get("username-is-secret");
                    String passphraseID = (String)tags.get("passphrase-id");
                    Secret passphrase = null;
                    boolean usernameSecret = false;
                    if (StringUtils.isNotBlank((CharSequence)usernameSecretTag)) {
                        usernameSecret = Boolean.parseBoolean(usernameSecretTag);
                    }
                    if (StringUtils.isNotBlank((CharSequence)passphraseID)) {
                        try {
                            passphrase = new KeyVaultSecretRetriever(client, keyVaultURL + "secrets/" + passphraseID).get();
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, "Could not find passphrase with ID " + passphraseID + " in KeyVault.");
                            return null;
                        }
                    }
                    return new AzureSSHUserPrivateKeyCredentials(scope, jenkinsID, description, (String)tags.get("username"), usernameSecret, passphrase, new KeyVaultSecretRetriever(client, id));
                }
                case "certificate": {
                    String passwordId = (String)tags.get("password-id");
                    KeyVaultSecretRetriever password = () -> Secret.fromString((String)"");
                    if (StringUtils.isNotBlank((CharSequence)passwordId)) {
                        try {
                            password = new KeyVaultSecretRetriever(client, keyVaultURL + "secrets/" + passwordId);
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, "Could not find password with ID " + passwordId + " in KeyVault.");
                            return null;
                        }
                    }
                    return new AzureCertificateCredentials(scope, jenkinsID, description, password, new KeyVaultSecretRetriever(client, id));
                }
            }
            throw new IllegalStateException("Unknown type: " + type);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error retrieving secret with id " + id + " from Azure KeyVault: " + e.getMessage(), e);
            return null;
        }
    }

    public static String extractLabelSelector() {
        return StringUtils.isNotBlank((CharSequence)System.getenv("AZURE_KEYVAULT_LABEL_SELECTOR")) ? System.getenv("AZURE_KEYVAULT_LABEL_SELECTOR") : System.getProperty("jenkins.azure-keyvault.label_selector");
    }

    public CredentialsStore getStore(ModelObject object) {
        return object == Jenkins.get() ? this.store : null;
    }

    public String getIconClassName() {
        return "icon-azure-key-vault-credentials-store";
    }

    private static class KeyVaultSecretRetriever
    implements Supplier<Secret> {
        private final transient SecretClient client;
        private final String secretId;

        public KeyVaultSecretRetriever(SecretClient secretClient, String secretId) {
            this.client = secretClient;
            this.secretId = secretId;
        }

        public String retrieveSecret() {
            URL secretIdentifierUrl;
            int NAME_POSITION = 2;
            int VERSION_POSITION = 3;
            try {
                secretIdentifierUrl = new URL(this.secretId);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            String[] split = secretIdentifierUrl.getPath().split("/");
            if (split.length == NAME_POSITION + 1) {
                return this.client.getSecret(split[NAME_POSITION]).getValue();
            }
            return this.client.getSecret(split[NAME_POSITION], split[VERSION_POSITION]).getValue();
        }

        @Override
        public Secret get() {
            return Secret.fromString((String)this.retrieveSecret());
        }
    }
}

