/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azurekeyvaultplugin;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.azure.util.AzureImdsCredentials;
import hudson.FilePath;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Base64;
import java.util.Enumeration;
import jenkins.model.Jenkins;

class AzureKeyVaultUtil {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final String PKCS12 = "PKCS12";
    private static final String PEM_CONTENT_TYPE = "application/x-pem-file";

    AzureKeyVaultUtil() {
    }

    static String saveCertificateToDisk(String contentType, FilePath workspace, String secret) throws IOException, InterruptedException, GeneralSecurityException {
        if (PEM_CONTENT_TYPE.equals(contentType)) {
            return AzureKeyVaultUtil.savePemToDisk(workspace, secret);
        }
        return AzureKeyVaultUtil.convertAndWritePfxToDisk(workspace, secret);
    }

    private static String savePemToDisk(FilePath workspace, String secret) throws IOException, InterruptedException {
        workspace.mkdirs();
        FilePath outFile = workspace.createTextTempFile("keyvault-", ".pem", secret);
        URI uri = outFile.toURI();
        return uri.getPath();
    }

    static String convertAndWritePfxToDisk(FilePath workspace, String secret) throws IOException, GeneralSecurityException, InterruptedException {
        byte[] bytes = Base64.getDecoder().decode(secret);
        KeyStore ks = KeyStore.getInstance(PKCS12);
        ks.load(new ByteArrayInputStream(bytes), EMPTY_CHAR_ARRAY);
        KeyStore ks2 = KeyStore.getInstance(PKCS12);
        ks2.load(null, null);
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            Certificate[] chain = ks.getCertificateChain(alias);
            Key privateKey = ks.getKey(alias, EMPTY_CHAR_ARRAY);
            ks2.setKeyEntry(alias, privateKey, EMPTY_CHAR_ARRAY, chain);
        }
        workspace.mkdirs();
        FilePath outFile = workspace.createTempFile("keyvault-", ".pfx");
        try (OutputStream outFileStream = outFile.write();){
            ks2.store(outFileStream, EMPTY_CHAR_ARRAY);
        }
        URI uri = outFile.toURI();
        return uri.getPath();
    }

    public static ListBoxModel doFillCredentialIDItems(Item context) {
        if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.CONFIGURE)) {
            return new StandardListBoxModel();
        }
        return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM2, context, AzureImdsCredentials.class).includeAs(ACL.SYSTEM2, context, AzureCredentials.class);
    }
}

