/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azurekeyvaultplugin;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.google.common.util.concurrent.FutureCallback;
import com.microsoft.azure.util.AzureCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.console.ConsoleLogFilter;
import hudson.model.Item;
import hudson.model.Run;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.login.CredentialNotFoundException;
import jenkins.YesNoMaybe;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultCredentialRetriever;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultEnvironmentExpander;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultException;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultGlobalConfiguration;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultSecret;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureKeyVaultUtil;
import org.jenkinsci.plugins.azurekeyvaultplugin.MaskingConsoleLogFilter;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatterns;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

public class AzureKeyVaultStep
extends Step {
    private final List<AzureKeyVaultSecret> secrets;
    private String keyVaultURL;
    private String credentialID;

    @DataBoundConstructor
    public AzureKeyVaultStep(List<AzureKeyVaultSecret> secrets) {
        this.secrets = secrets;
    }

    public List<AzureKeyVaultSecret> getSecrets() {
        return this.secrets;
    }

    public String getKeyVaultURL() {
        return this.keyVaultURL;
    }

    @DataBoundSetter
    public void setKeyVaultURL(String keyVaultURL) {
        this.keyVaultURL = Util.fixEmpty((String)keyVaultURL);
    }

    public String getCredentialID() {
        return this.credentialID;
    }

    @DataBoundSetter
    public void setCredentialID(String credentialID) {
        this.credentialID = Util.fixEmpty((String)credentialID);
    }

    public StepExecution start(StepContext context) throws Exception {
        AzureKeyVaultGlobalConfiguration globalConfiguration = AzureKeyVaultGlobalConfiguration.get();
        String resolvedKeyVaultUrl = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.keyVaultURL, globalConfiguration.getKeyVaultURL()});
        if (StringUtils.isEmpty((CharSequence)resolvedKeyVaultUrl)) {
            throw new AzureKeyVaultException("No key vault url configured, set one globally or in the build wrap step");
        }
        String resolvedCredentialId = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.credentialID, globalConfiguration.getCredentialID()});
        if (StringUtils.isEmpty((CharSequence)resolvedCredentialId)) {
            throw new CredentialNotFoundException("Unable to find a valid credential with provided parameters");
        }
        return new ExecutionImpl(context, resolvedKeyVaultUrl, resolvedCredentialId, this.secrets);
    }

    static class ExecutionImpl
    extends AbstractStepExecutionImpl {
        private final String keyVaultURL;
        private String credentialId;
        private final List<AzureKeyVaultSecret> azureKeyVaultSecrets;
        private String applicationId;
        private String applicationSecret;
        private String tenantId;
        private static final long serialVersionUID = 1L;

        ExecutionImpl(StepContext context, String keyVaultURL, String credentialId, List<AzureKeyVaultSecret> azureKeyVaultSecrets) {
            super(context);
            this.keyVaultURL = keyVaultURL;
            this.credentialId = credentialId;
            this.azureKeyVaultSecrets = azureKeyVaultSecrets;
        }

        ExecutionImpl(StepContext context, String keyVaultURL, String applicationId, String applicationSecret, String tenantId, List<AzureKeyVaultSecret> azureKeyVaultSecrets) {
            super(context);
            this.keyVaultURL = keyVaultURL;
            this.applicationId = applicationId;
            this.applicationSecret = applicationSecret;
            this.tenantId = tenantId;
            this.azureKeyVaultSecrets = azureKeyVaultSecrets;
        }

        private boolean isLegacyAuth() {
            return StringUtils.isNotEmpty((CharSequence)this.applicationId) && StringUtils.isNotEmpty((CharSequence)this.applicationSecret) && StringUtils.isNotEmpty((CharSequence)this.tenantId);
        }

        private TokenCredential getCredential(Run<?, ?> run) {
            if (this.isLegacyAuth()) {
                return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.applicationId)).clientSecret(this.applicationSecret).httpClient(HttpClientRetriever.get())).tenantId(this.tenantId)).build();
            }
            return AzureKeyVaultCredentialRetriever.getCredentialById(this.credentialId, run);
        }

        public boolean start() throws Exception {
            StepContext context = this.getContext();
            BodyInvoker invoker = context.newBodyInvoker().withCallback(BodyExecutionCallback.wrap((FutureCallback)context));
            Run run = (Run)context.get(Run.class);
            TokenCredential credential = this.getCredential(run);
            Map<String, String> secrets = this.getSecretsMap(credential, this.keyVaultURL, this.azureKeyVaultSecrets);
            invoker.withContexts(new Object[]{EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)context.get(EnvironmentExpander.class)), (EnvironmentExpander)new AzureKeyVaultEnvironmentExpander(secrets)), BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)((ConsoleLogFilter)context.get(ConsoleLogFilter.class)), (ConsoleLogFilter)new MaskingConsoleLogFilter(StandardCharsets.UTF_8.name(), SecretPatterns.getAggregateSecretPattern(secrets.values())))});
            invoker.start();
            return false;
        }

        private KeyVaultSecret getSecret(SecretClient client, AzureKeyVaultSecret secret) {
            return AzureKeyVaultCredentialRetriever.getSecretBundle(client, secret);
        }

        private Map<String, String> getSecretsMap(TokenCredential credential, String keyVaultURL, List<AzureKeyVaultSecret> azureKeyVaultSecrets) {
            if (azureKeyVaultSecrets == null || azureKeyVaultSecrets.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, String> secrets = new HashMap<String, String>();
            SecretClient client = AzureCredentials.createKeyVaultClient((TokenCredential)credential, (String)keyVaultURL);
            for (AzureKeyVaultSecret secret : azureKeyVaultSecrets) {
                KeyVaultSecret bundle;
                if (secret.isPassword()) {
                    bundle = this.getSecret(client, secret);
                    if (bundle != null) {
                        secrets.put(secret.getEnvVariable(), bundle.getValue());
                        continue;
                    }
                    throw new AzureKeyVaultException(String.format("Secret: %s not found in vault: %s", secret.getName(), keyVaultURL));
                }
                if (!secret.isCertificate()) continue;
                bundle = this.getSecret(client, secret);
                if (bundle != null) {
                    try {
                        FilePath filePath = Objects.requireNonNull((FilePath)this.getContext().get(FilePath.class), "A certificate requires a `node`");
                        String path = AzureKeyVaultUtil.saveCertificateToDisk(bundle.getProperties().getContentType(), filePath, bundle.getValue());
                        secrets.put(secret.getEnvVariable(), path);
                        continue;
                    }
                    catch (Exception e) {
                        throw new AzureKeyVaultException(e.getMessage(), e);
                    }
                }
                throw new AzureKeyVaultException(String.format("Certificate: %s not found in vault: %s", secret.getName(), keyVaultURL));
            }
            return secrets;
        }

        public void stop(@NonNull Throwable cause) {
            this.getContext().onFailure(cause);
        }
    }

    @Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Bind credentials in Azure Key Vault to environment variables";
        }

        @POST
        public ListBoxModel doFillCredentialIDItems(@AncestorInPath Item context) {
            return AzureKeyVaultUtil.doFillCredentialIDItems(context);
        }

        public String getFunctionName() {
            return "azureKeyVault";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(Run.class);
        }
    }
}

