/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.util;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.FixedDelay;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.profile.AzureProfile;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.resources.models.Subscription;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.microsoft.azure.util.AbstractManagedIdentitiesCredentials;
import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.azure.util.AzureEnvUtil;
import com.microsoft.azure.util.Messages;
import hudson.Extension;
import hudson.Main;
import hudson.Util;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.time.Duration;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AzureImdsCredentials
extends AbstractManagedIdentitiesCredentials {
    private String subscriptionId;
    private String clientId;

    public AzureImdsCredentials(CredentialsScope scope, String id, String description) {
        super(scope, id, description);
    }

    @DataBoundConstructor
    public AzureImdsCredentials(CredentialsScope scope, String id, String description, String azureEnvName) {
        super(scope, id, description);
        this.setAzureEnvName(azureEnvName);
        this.setAzureEnvironment(AzureEnvUtil.resolveAzureEnv(azureEnvName));
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @DataBoundSetter
    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = Util.fixEmpty((String)subscriptionId);
    }

    public String getClientId() {
        return Util.fixEmpty((String)this.clientId);
    }

    @DataBoundSetter
    public void setClientId(String clientId) {
        this.clientId = Util.fixEmpty((String)clientId);
    }

    public boolean validate() throws AzureCredentials.ValidationException {
        block5: {
            try {
                String credentialSubscriptionId = this.getSubscriptionId();
                AzureProfile profile = new AzureProfile(AzureEnvUtil.resolveAzureEnv(this.getAzureEnvName()));
                ManagedIdentityCredentialBuilder credentialBuilder = new ManagedIdentityCredentialBuilder();
                if (this.getClientId() != null) {
                    credentialBuilder.clientId(this.getClientId());
                }
                AzureResourceManager azure = ((AzureResourceManager.Configurable)((AzureResourceManager.Configurable)AzureResourceManager.configure().withRetryPolicy(AzureImdsCredentials.getRetryPolicy())).withHttpClient(HttpClientRetriever.get())).authenticate((TokenCredential)credentialBuilder.build(), profile).withSubscription(credentialSubscriptionId);
                PagedIterable subscriptions = azure.subscriptions().list();
                if (this.subscriptionId != null) {
                    for (Subscription subscription : subscriptions) {
                        if (!subscription.subscriptionId().equalsIgnoreCase(credentialSubscriptionId)) continue;
                        return true;
                    }
                    break block5;
                }
                return true;
            }
            catch (Exception e) {
                throw new AzureCredentials.ValidationException(Messages.Azure_CantValidate() + ": " + e.getMessage(), e);
            }
        }
        throw new AzureCredentials.ValidationException(Messages.Azure_Invalid_SubscriptionId());
    }

    private static RetryPolicy getRetryPolicy() {
        return Main.isUnitTest ? new RetryPolicy((RetryStrategy)new FixedDelay(0, Duration.ZERO)) : new RetryPolicy();
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Azure Managed Identity";
        }

        public ListBoxModel doFillAzureEnvNameItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Azure");
            model.add("Azure China");
            model.add("Azure US Government");
            return model;
        }

        @POST
        public FormValidation doVerifyConfiguration(@AncestorInPath Item owner, @QueryParameter String subscriptionId, @QueryParameter String clientId, @QueryParameter String azureEnvironmentName) {
            if (owner == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                owner.checkPermission(Item.CONFIGURE);
            }
            AzureImdsCredentials imdsCredentials = new AzureImdsCredentials(null, null, null, azureEnvironmentName);
            if (StringUtils.isNotBlank((CharSequence)subscriptionId)) {
                imdsCredentials.setSubscriptionId(subscriptionId);
            }
            if (StringUtils.isNotBlank((CharSequence)clientId)) {
                imdsCredentials.setClientId(clientId);
            }
            try {
                imdsCredentials.validate();
            }
            catch (AzureCredentials.ValidationException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok((String)Messages.Azure_MI_Config_Success());
        }
    }
}

