/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.util;

import com.azure.core.management.AzureEnvironment;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public final class AzureEnvUtil {
    static boolean resolveOverride(AzureEnvironment environment, AzureEnvironment.Endpoint endpoint, String stored) {
        if (StringUtils.isBlank((CharSequence)stored)) {
            return false;
        }
        String defaultValue = (String)environment.getEndpoints().get(endpoint.identifier());
        if (StringUtils.isBlank((CharSequence)defaultValue)) {
            environment.getEndpoints().put(endpoint.identifier(), stored);
            return true;
        }
        if (AzureEnvUtil.isOverridden(defaultValue, stored)) {
            environment.getEndpoints().put(endpoint.identifier(), stored);
            return true;
        }
        return false;
    }

    static boolean isOverridden(String defaultURL, String overrideURL) {
        return StringUtils.isNotBlank((CharSequence)overrideURL) && !defaultURL.replaceAll("/+$", "").equalsIgnoreCase(overrideURL.replaceAll("/+$", ""));
    }

    static AzureEnvironment resolveAzureEnv(String envName) {
        AzureEnvironment env = "Azure".equalsIgnoreCase(envName) ? AzureEnvironment.AZURE : ("Azure China".equalsIgnoreCase(envName) ? AzureEnvironment.AZURE_CHINA : ("Azure Germany".equalsIgnoreCase(envName) ? AzureEnvironment.AZURE_GERMANY : ("Azure US Government".equalsIgnoreCase(envName) ? AzureEnvironment.AZURE_US_GOVERNMENT : AzureEnvironment.AZURE)));
        return new AzureEnvironment(new HashMap(env.getEndpoints()));
    }

    private AzureEnvUtil() {
    }

    public static class Constants {
        static final String ENV_AZURE = "Azure";
        static final String ENV_AZURE_CHINA = "Azure China";
        static final String ENV_AZURE_GERMANY = "Azure Germany";
        static final String ENV_AZURE_US_GOVERNMENT = "Azure US Government";
    }
}

