/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.credentials;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.AzureResourceManager;
import com.microsoft.azure.util.AzureBaseCredentials;
import com.microsoft.azure.util.AzureCredentialUtil;
import com.microsoft.azure.util.AzureCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;

public final class AzureResourceManagerRetriever {
    private AzureResourceManagerRetriever() {
    }

    public static AzureResourceManager getClient(String credentialId, @CheckForNull String subscriptionId) {
        AzureBaseCredentials credential = AzureCredentialUtil.getCredential(null, credentialId);
        if (credential == null) {
            return null;
        }
        String actualSubscriptionId = subscriptionId != null ? subscriptionId : credential.getSubscriptionId();
        return AzureResourceManagerRetriever.getAzureResourceManager(credential, actualSubscriptionId);
    }

    private static AzureResourceManager getAzureResourceManager(AzureBaseCredentials azureCredentials, @CheckForNull String subscriptionId) {
        AzureProfile profile = new AzureProfile(azureCredentials.getAzureEnvironment());
        TokenCredential tokenCredential = AzureCredentials.getTokenCredential(azureCredentials);
        AzureResourceManager.Authenticated builder = ((AzureResourceManager.Configurable)AzureResourceManager.configure().withHttpClient(HttpClientRetriever.get())).authenticate(tokenCredential, profile);
        if (Util.fixEmpty((String)subscriptionId) == null) {
            return builder.withDefaultSubscription();
        }
        return builder.withSubscription(subscriptionId);
    }
}

