/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.util;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.profile.AzureProfile;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.resources.models.Subscription;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.microsoft.azure.util.AzureBaseCredentials;
import com.microsoft.azure.util.AzureCredentialUtil;
import com.microsoft.azure.util.AzureEnvUtil;
import com.microsoft.azure.util.AzureImdsCredentials;
import com.microsoft.azure.util.Messages;
import com.microsoft.jenkins.credentials.AzureResourceManagerCache;
import com.microsoft.jenkins.credentials.BlobServiceClientCache;
import com.microsoft.jenkins.keyvault.SecretClientCache;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class AzureCredentials
extends AzureBaseCredentials {
    private final ServicePrincipal data;

    @Deprecated
    public AzureCredentials(CredentialsScope scope, String id, String description, String subscriptionId, String clientId, String clientSecret) {
        super(scope, id, description);
        this.data = new ServicePrincipal(subscriptionId, clientId, Secret.fromString((String)clientSecret));
    }

    @DataBoundConstructor
    public AzureCredentials(CredentialsScope scope, String id, String description, String subscriptionId, String clientId, Secret clientSecret) {
        super(scope, id, description);
        this.data = new ServicePrincipal(subscriptionId, clientId, clientSecret);
        SecretClientCache.invalidateCache();
        AzureResourceManagerCache.invalidateCache();
        BlobServiceClientCache.invalidateCache();
    }

    @Deprecated
    public AzureCredentials(CredentialsScope scope, String id, String description, String subscriptionId, String clientId, String clientSecret, String oauth2TokenEndpoint, String serviceManagementURL, String authenticationEndpoint, String resourceManagerEndpoint, String graphEndpoint) {
        super(scope, id, description);
        this.data = new ServicePrincipal(subscriptionId, clientId, Secret.fromString((String)clientSecret));
        this.data.setTenant(ServicePrincipal.getTenantFromTokenEndpoint(oauth2TokenEndpoint));
        this.data.setManagementEndpoint(serviceManagementURL);
        this.data.setActiveDirectoryEndpoint(authenticationEndpoint);
        this.data.setResourceManagerEndpoint(resourceManagerEndpoint);
        this.data.setGraphEndpoint(graphEndpoint);
    }

    @Deprecated
    public static ServicePrincipal getServicePrincipal(String credentialsId) {
        AzureCredentials creds = (AzureCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(AzureCredentials.class, (ItemGroup)Jenkins.getInstance(), (org.acegisecurity.Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (creds == null) {
            return new ServicePrincipal();
        }
        return creds.data;
    }

    public static SecretClient createKeyVaultClient(TokenCredential credential, String keyVaultUrl) {
        return new SecretClientBuilder().vaultUrl(keyVaultUrl).credential(credential).httpClient(HttpClientRetriever.get()).buildClient();
    }

    public static TokenCredential getSystemCredentialById(String credentialID) {
        if (StringUtils.isEmpty((String)credentialID)) {
            return null;
        }
        SystemCredentialsProvider systemCredentialsProvider = SystemCredentialsProvider.getInstance();
        List azureImdsCredentials = DomainCredentials.getCredentials((Map)systemCredentialsProvider.getDomainCredentialsMap(), AzureImdsCredentials.class, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialID));
        if (!azureImdsCredentials.isEmpty()) {
            AzureImdsCredentials azureIdmsCredential = (AzureImdsCredentials)((Object)azureImdsCredentials.get(0));
            ManagedIdentityCredentialBuilder credentialBuilder = new ManagedIdentityCredentialBuilder();
            if (azureIdmsCredential.getClientId() != null) {
                credentialBuilder.clientId(azureIdmsCredential.getClientId());
            }
            return credentialBuilder.build();
        }
        List azureCredentials = DomainCredentials.getCredentials((Map)systemCredentialsProvider.getDomainCredentialsMap(), AzureCredentials.class, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialID));
        ClientSecretCredential credential = null;
        if (!azureCredentials.isEmpty()) {
            AzureCredentials azureCredential = (AzureCredentials)((Object)azureCredentials.get(0));
            credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().authorityHost(azureCredential.getAzureEnvironment().getActiveDirectoryEndpoint())).clientId(azureCredential.getClientId())).clientSecret(azureCredential.getPlainClientSecret()).httpClient(HttpClientRetriever.get())).tenantId(azureCredential.getTenant())).build();
        }
        if (credential == null) {
            throw new RuntimeException(String.format("Credential: %s was not found for supported credentials type.", credentialID));
        }
        return credential;
    }

    private static <T extends Credentials> T getCredentials(Class<T> type, String certificateId, Authentication authentication) {
        return (T)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(type, (ItemGroup)Jenkins.get(), (Authentication)authentication, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)certificateId));
    }

    public static TokenCredential getTokenCredential(AzureBaseCredentials credentials) {
        if (credentials instanceof AzureCredentials) {
            AzureCredentials azureCredentials = (AzureCredentials)credentials;
            String secret = azureCredentials.getPlainClientSecret();
            if (StringUtils.isEmpty((String)secret) && StringUtils.isNotBlank((String)azureCredentials.getCertificateId())) {
                byte[] pkcs12Bytes;
                StandardCertificateCredentials certificate = AzureCredentials.getCertificateCredentials(azureCredentials);
                try {
                    pkcs12Bytes = ServicePrincipal.getPfxBytes(certificate.getKeyStore(), certificate.getPassword());
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new RuntimeException(e);
                }
                ByteArrayInputStream certificateBytes = new ByteArrayInputStream(pkcs12Bytes);
                IdentityClientOptions identityClientOptions = new IdentityClientOptions();
                identityClientOptions.setHttpClient(HttpClientRetriever.get());
                return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().clientId(azureCredentials.getClientId())).pfxCertificate((InputStream)certificateBytes).tenantId(azureCredentials.getTenant())).authorityHost(azureCredentials.getAzureEnvironment().getActiveDirectoryEndpoint())).httpClient(HttpClientRetriever.get())).build();
            }
            return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(azureCredentials.getClientId())).clientSecret(azureCredentials.getPlainClientSecret()).tenantId(azureCredentials.getTenant())).authorityHost(azureCredentials.getAzureEnvironment().getActiveDirectoryEndpoint())).httpClient(HttpClientRetriever.get())).build();
        }
        if (credentials instanceof AzureImdsCredentials) {
            AzureImdsCredentials idmsCredentials = (AzureImdsCredentials)credentials;
            ManagedIdentityCredentialBuilder credentialBuilder = (ManagedIdentityCredentialBuilder)new ManagedIdentityCredentialBuilder().httpClient(HttpClientRetriever.get());
            if (idmsCredentials.getClientId() != null) {
                credentialBuilder.clientId(idmsCredentials.getClientId());
            }
            return credentialBuilder.build();
        }
        throw new RuntimeException(String.format("Unsupported credential: %s", credentials.getId()));
    }

    private static StandardCertificateCredentials getCertificateCredentials(AzureCredentials azureCredentials) {
        String certificateId = azureCredentials.getCertificateId();
        StandardCertificateCredentials certificate = AzureCredentials.getCredentials(StandardCertificateCredentials.class, certificateId, ACL.SYSTEM2);
        if (certificate == null) {
            certificate = AzureCredentials.getCredentials(StandardCertificateCredentials.class, certificateId, Jenkins.getAuthentication2());
        }
        if (certificate == null) {
            throw new RuntimeException("Couldn't find certificate: " + azureCredentials.getCertificateId());
        }
        return certificate;
    }

    public static TokenCredential getCredentialById(Item owner, String credentialId) {
        return AzureCredentials.getTokenCredential(AzureCredentialUtil.getCredential(owner, credentialId));
    }

    @Override
    public String getSubscriptionId() {
        return this.data.subscriptionId.getPlainText();
    }

    public String getClientId() {
        return this.data.clientId.getPlainText();
    }

    public Secret getClientSecret() {
        return this.data.clientSecret;
    }

    public String getPlainClientSecret() {
        return this.data.clientSecret.getPlainText();
    }

    @DataBoundSetter
    public void setCertificateId(String certificateId) {
        this.data.setCertificateId(certificateId);
    }

    public String getCertificateId() {
        return this.data.getCertificateId();
    }

    public String getTenant() {
        return this.data.getTenant();
    }

    @DataBoundSetter
    public void setTenant(String tenant) {
        this.data.setTenant(tenant);
    }

    @Deprecated
    public String getOauth2TokenEndpoint() {
        return "https://login.windows.net/" + this.data.getTenant();
    }

    @DataBoundSetter
    @Deprecated
    public void setOauth2TokenEndpoint(String oauth2TokenEndpoint) {
        this.data.setOauth2TokenEndpoint(oauth2TokenEndpoint);
    }

    @Deprecated
    public String getAzureEnvionmentName() {
        return this.data.getAzureEnvironmentName();
    }

    @Override
    public String getAzureEnvironmentName() {
        return this.data.getAzureEnvironmentName();
    }

    @DataBoundSetter
    public void setAzureEnvironmentName(String azureEnvironmentName) {
        this.data.setAzureEnvironmentName(azureEnvironmentName);
    }

    @Deprecated
    public String getServiceManagementURL() {
        return this.getManagementEndpoint();
    }

    @Override
    public String getManagementEndpoint() {
        return this.data.serviceManagementURL;
    }

    @DataBoundSetter
    @Deprecated
    public void setServiceManagementURL(String serviceManagementURL) {
        this.setManagementEndpoint(serviceManagementURL);
    }

    @DataBoundSetter
    public void setManagementEndpoint(String managementEndpoint) {
        this.data.setManagementEndpoint(managementEndpoint);
    }

    @Deprecated
    public String getAuthenticationEndpoint() {
        return this.getActiveDirectoryEndpoint();
    }

    @Override
    public String getActiveDirectoryEndpoint() {
        return this.data.authenticationEndpoint;
    }

    @DataBoundSetter
    @Deprecated
    public void setAuthenticationEndpoint(String authenticationEndpoint) {
        this.setActiveDirectoryEndpoint(authenticationEndpoint);
    }

    @DataBoundSetter
    public void setActiveDirectoryEndpoint(String activeDirectoryEndpoint) {
        this.data.setActiveDirectoryEndpoint(activeDirectoryEndpoint);
    }

    @Override
    public String getResourceManagerEndpoint() {
        return this.data.resourceManagerEndpoint;
    }

    @DataBoundSetter
    public void setResourceManagerEndpoint(String resourceManagerEndpoint) {
        this.data.setResourceManagerEndpoint(resourceManagerEndpoint);
    }

    @Override
    public AzureEnvironment getAzureEnvironment() {
        return this.data.getAzureEnvironment();
    }

    @Override
    public String getGraphEndpoint() {
        return this.data.graphEndpoint;
    }

    @DataBoundSetter
    public void setGraphEndpoint(String graphEndpoint) {
        this.data.setGraphEndpoint(graphEndpoint);
    }

    public static class ServicePrincipal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Secret subscriptionId;
        private final Secret clientId;
        private final Secret clientSecret;
        private String certificateId;
        private Secret oauth2TokenEndpoint;
        private String serviceManagementURL;
        private Secret tenant;
        private String authenticationEndpoint;
        private String resourceManagerEndpoint;
        private String graphEndpoint;
        private String azureEnvironmentName;
        private transient AzureEnvironment azureEnvironment;
        private static final int TOKEN_ENDPOINT_URL_ENDPOINT_POSTION = 3;

        private Object readResolve() throws ObjectStreamException {
            return this;
        }

        public String getSubscriptionId() {
            if (this.subscriptionId == null) {
                return "";
            }
            return this.subscriptionId.getPlainText();
        }

        public String getClientId() {
            if (this.clientId == null) {
                return "";
            }
            return this.clientId.getPlainText();
        }

        public String getClientSecret() {
            if (this.clientSecret == null) {
                return "";
            }
            return this.clientSecret.getPlainText();
        }

        public String getCertificateId() {
            return this.certificateId;
        }

        public void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Nullable
        StandardCertificateCredentials getCertificate() {
            if (StringUtils.isNotEmpty((String)this.clientSecret.getPlainText())) {
                return null;
            }
            if (StringUtils.isEmpty((String)this.certificateId)) {
                return null;
            }
            StandardCertificateCredentials certificate = AzureCredentials.getCredentials(StandardCertificateCredentials.class, this.certificateId, ACL.SYSTEM2);
            if (certificate == null) {
                return AzureCredentials.getCredentials(StandardCertificateCredentials.class, this.certificateId, Jenkins.getAuthentication2());
            }
            return certificate;
        }

        public String getTenant() {
            if (this.tenant == null || StringUtils.isBlank((String)this.tenant.getPlainText())) {
                if (this.oauth2TokenEndpoint != null) {
                    return ServicePrincipal.getTenantFromTokenEndpoint(this.oauth2TokenEndpoint.getPlainText());
                }
                return ServicePrincipal.getTenantFromTokenEndpoint("");
            }
            return this.tenant.getPlainText();
        }

        public String getAzureEnvironmentName() {
            return this.azureEnvironmentName;
        }

        public AzureEnvironment getAzureEnvironment() {
            if (this.azureEnvironment != null) {
                return this.azureEnvironment;
            }
            String envName = this.getAzureEnvironmentName();
            this.azureEnvironment = AzureEnvUtil.resolveAzureEnv(envName);
            AzureEnvUtil.resolveOverride(this.azureEnvironment, AzureEnvironment.Endpoint.MANAGEMENT, this.serviceManagementURL);
            AzureEnvUtil.resolveOverride(this.azureEnvironment, AzureEnvironment.Endpoint.ACTIVE_DIRECTORY, this.authenticationEndpoint);
            AzureEnvUtil.resolveOverride(this.azureEnvironment, AzureEnvironment.Endpoint.RESOURCE_MANAGER, this.resourceManagerEndpoint);
            AzureEnvUtil.resolveOverride(this.azureEnvironment, AzureEnvironment.Endpoint.GRAPH, this.graphEndpoint);
            return this.azureEnvironment;
        }

        @Deprecated
        public String getServiceManagementURL() {
            return this.getManagementEndpoint();
        }

        public String getManagementEndpoint() {
            AzureEnvironment env = this.getAzureEnvironment();
            return env.getManagementEndpoint();
        }

        @Deprecated
        public String getAuthenticationEndpoint() {
            return this.getActiveDirectoryEndpoint();
        }

        public String getActiveDirectoryEndpoint() {
            AzureEnvironment env = this.getAzureEnvironment();
            return env.getActiveDirectoryEndpoint();
        }

        public String getResourceManagerEndpoint() {
            AzureEnvironment env = this.getAzureEnvironment();
            return env.getResourceManagerEndpoint();
        }

        public String getGraphEndpoint() {
            AzureEnvironment env = this.getAzureEnvironment();
            return env.getGraphEndpoint();
        }

        @Deprecated
        void setOauth2TokenEndpoint(String oauth2TokenEndpoint) {
            this.oauth2TokenEndpoint = null;
            if (StringUtils.isNotBlank((String)oauth2TokenEndpoint)) {
                this.tenant = Secret.fromString((String)ServicePrincipal.getTenantFromTokenEndpoint(oauth2TokenEndpoint));
            }
        }

        void setTenant(String tenant) {
            this.tenant = Secret.fromString((String)tenant);
            if (StringUtils.isNotBlank((String)this.tenant.getPlainText())) {
                this.oauth2TokenEndpoint = null;
            }
        }

        void setManagementEndpoint(String managementEndpoint) {
            this.serviceManagementURL = StringUtils.trimToNull((String)managementEndpoint);
            this.azureEnvironment = null;
        }

        void setActiveDirectoryEndpoint(String activeDirectoryEndpoint) {
            this.authenticationEndpoint = StringUtils.trimToNull((String)activeDirectoryEndpoint);
            this.azureEnvironment = null;
        }

        void setResourceManagerEndpoint(String resourceManagerEndpoint) {
            this.resourceManagerEndpoint = StringUtils.trimToNull((String)resourceManagerEndpoint);
            this.azureEnvironment = null;
        }

        void setGraphEndpoint(String graphEndpoint) {
            this.graphEndpoint = StringUtils.trimToNull((String)graphEndpoint);
            this.azureEnvironment = null;
        }

        void setAzureEnvironmentName(String azureEnvironmentName) {
            this.azureEnvironmentName = azureEnvironmentName;
            this.azureEnvironment = null;
        }

        public ServicePrincipal(String subscriptionId, String clientId, Secret clientSecret) {
            this.subscriptionId = Secret.fromString((String)subscriptionId);
            this.clientId = Secret.fromString((String)clientId);
            this.clientSecret = clientSecret != null ? clientSecret : Secret.fromString((String)"");
            this.tenant = Secret.fromString((String)"");
        }

        @Deprecated
        public ServicePrincipal(String subscriptionId, String clientId, String clientSecret) {
            this(subscriptionId, clientId, Secret.fromString((String)clientSecret));
        }

        @Deprecated
        public ServicePrincipal(String subscriptionId, String clientId, String clientSecret, String oauth2TokenEndpoint, String serviceManagementURL, String authenticationEndpoint, String resourceManagerEndpoint, String graphEndpoint) {
            this.subscriptionId = Secret.fromString((String)subscriptionId);
            this.clientId = Secret.fromString((String)clientId);
            this.clientSecret = Secret.fromString((String)clientSecret);
            this.tenant = Secret.fromString((String)ServicePrincipal.getTenantFromTokenEndpoint(oauth2TokenEndpoint));
            this.serviceManagementURL = StringUtils.trimToNull((String)serviceManagementURL);
            this.authenticationEndpoint = StringUtils.trimToNull((String)authenticationEndpoint);
            this.resourceManagerEndpoint = StringUtils.trimToNull((String)resourceManagerEndpoint);
            this.graphEndpoint = StringUtils.trimToNull((String)graphEndpoint);
        }

        public ServicePrincipal() {
            this.subscriptionId = Secret.fromString((String)"");
            this.clientId = Secret.fromString((String)"");
            this.clientSecret = Secret.fromString((String)"");
            this.tenant = Secret.fromString((String)"");
        }

        public boolean isBlank() {
            return StringUtils.isBlank((String)this.subscriptionId.getPlainText()) || StringUtils.isBlank((String)this.clientId.getPlainText()) || StringUtils.isBlank((String)this.getTenant()) || StringUtils.isBlank((String)this.clientSecret.getPlainText());
        }

        public boolean validate() throws ValidationException {
            if (StringUtils.isBlank((String)this.subscriptionId.getPlainText())) {
                throw new ValidationException(Messages.Azure_SubscriptionID_Missing());
            }
            if (StringUtils.isBlank((String)this.clientId.getPlainText())) {
                throw new ValidationException(Messages.Azure_ClientID_Missing());
            }
            String secret = this.clientSecret.getPlainText();
            if (StringUtils.isEmpty((String)secret) && StringUtils.isBlank((String)this.certificateId)) {
                throw new ValidationException(Messages.Azure_ClientSecret_Missing());
            }
            if (StringUtils.isBlank((String)this.getTenant())) {
                throw new ValidationException(Messages.Azure_OAuthToken_Malformed());
            }
            try {
                ClientSecretCredential credential;
                String credentialSubscriptionId = this.getSubscriptionId();
                AzureProfile profile = new AzureProfile(this.getAzureEnvironment());
                if (StringUtils.isEmpty((String)secret)) {
                    StandardCertificateCredentials certificate = this.getCertificate();
                    if (certificate == null) {
                        throw new ValidationException(Messages.Azure_ClientCertificate_NotFound());
                    }
                    byte[] pkcs12Bytes = ServicePrincipal.getPfxBytes(certificate.getKeyStore(), certificate.getPassword());
                    ByteArrayInputStream certificateBytes = new ByteArrayInputStream(pkcs12Bytes);
                    IdentityClientOptions identityClientOptions = new IdentityClientOptions();
                    identityClientOptions.setHttpClient(HttpClientRetriever.get());
                    credential = ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().authorityHost(profile.getEnvironment().getActiveDirectoryEndpoint())).clientId(this.getClientId())).pfxCertificate((InputStream)certificateBytes).tenantId(this.getTenant())).httpClient(HttpClientRetriever.get())).build();
                } else {
                    credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().authorityHost(profile.getEnvironment().getActiveDirectoryEndpoint())).clientId(this.getClientId())).clientSecret(this.getClientSecret()).tenantId(this.getTenant())).httpClient(HttpClientRetriever.get())).build();
                }
                AzureResourceManager azure = ((AzureResourceManager.Configurable)AzureResourceManager.configure().withHttpClient(HttpClientRetriever.get())).authenticate((TokenCredential)credential, profile).withSubscription(this.subscriptionId.getPlainText());
                for (Subscription subscription : azure.subscriptions().list()) {
                    if (!subscription.subscriptionId().equalsIgnoreCase(credentialSubscriptionId)) continue;
                    return true;
                }
            }
            catch (IOException | RuntimeException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new ValidationException(Messages.Azure_CantValidate() + ": " + e.getMessage(), e);
            }
            throw new ValidationException(Messages.Azure_Invalid_SubscriptionId());
        }

        private static byte[] getPfxBytes(KeyStore ks, Secret password) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
            String plainTextPassword = Secret.toString((Secret)password);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ks.store(out, plainTextPassword.toCharArray());
            return out.toByteArray();
        }

        private static String getTenantFromTokenEndpoint(String oauth2TokenEndpoint) {
            if (!oauth2TokenEndpoint.matches("https{0,1}://[a-zA-Z0-9.]*/[a-z0-9\\-]*/?.*$")) {
                return "";
            }
            String[] parts = oauth2TokenEndpoint.split("/");
            if (parts.length < 4) {
                return "";
            }
            return parts[3];
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return "Azure Service Principal";
        }

        @POST
        public FormValidation doVerifyConfiguration(@AncestorInPath Item owner, @QueryParameter String subscriptionId, @QueryParameter String clientId, @QueryParameter String clientSecret, @QueryParameter String certificateId, @QueryParameter String tenant, @QueryParameter String azureEnvironmentName, @QueryParameter String serviceManagementURL, @QueryParameter String authenticationEndpoint, @QueryParameter String resourceManagerEndpoint, @QueryParameter String graphEndpoint) {
            if (owner == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                owner.checkPermission(Item.CONFIGURE);
            }
            ServicePrincipal servicePrincipal = new ServicePrincipal(subscriptionId, clientId, Secret.fromString((String)clientSecret));
            servicePrincipal.setCertificateId(certificateId);
            servicePrincipal.setTenant(tenant);
            servicePrincipal.setAzureEnvironmentName(azureEnvironmentName);
            servicePrincipal.setManagementEndpoint(serviceManagementURL);
            servicePrincipal.setActiveDirectoryEndpoint(authenticationEndpoint);
            servicePrincipal.setResourceManagerEndpoint(resourceManagerEndpoint);
            servicePrincipal.setGraphEndpoint(graphEndpoint);
            try {
                servicePrincipal.validate();
            }
            catch (ValidationException e) {
                return FormValidation.error((Throwable)e, (String)e.getMessage());
            }
            return FormValidation.ok((String)Messages.Azure_Config_Success());
        }

        public ListBoxModel doFillCertificateIdItems(@AncestorInPath Item owner, @QueryParameter(value="certificateId") String certificateId) {
            StandardListBoxModel model = new StandardListBoxModel();
            model.add(Messages.Azure_Credentials_Select(), "");
            if (owner == null ? !Jenkins.get().hasPermission(CredentialsProvider.CREATE) && !Jenkins.get().hasPermission(CredentialsProvider.UPDATE) : !owner.hasPermission(CredentialsProvider.CREATE) && !owner.hasPermission(CredentialsProvider.UPDATE)) {
                return model.includeCurrentValue(certificateId);
            }
            return model.includeCurrentValue(certificateId).includeAs(Jenkins.getAuthentication2(), owner, StandardCertificateCredentials.class).includeAs(ACL.SYSTEM2, owner, StandardCertificateCredentials.class);
        }

        public ListBoxModel doFillAzureEnvironmentNameItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Azure");
            model.add("Azure China");
            model.add("Azure US Government");
            return model;
        }
    }

    public static class ValidationException
    extends Exception {
        public ValidationException(String message) {
            super(message);
        }

        public ValidationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

