/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.util;

import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.azure.util.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AzureCredentialsBinding
extends MultiBinding<AzureCredentials> {
    public static final String DEFAULT_SUBSCRIPTION_ID_VARIABLE = "AZURE_SUBSCRIPTION_ID";
    public static final String DEFAULT_CLIENT_ID_VARIABLE = "AZURE_CLIENT_ID";
    public static final String DEFAULT_CLIENT_SECRET_VARIABLE = "AZURE_CLIENT_SECRET";
    public static final String DEFAULT_TENANT_ID_VARIABLE = "AZURE_TENANT_ID";
    private String subscriptionIdVariable;
    private String clientIdVariable;
    private String clientSecretVariable;
    private String tenantIdVariable;

    @DataBoundConstructor
    public AzureCredentialsBinding(String credentialsId) {
        super(credentialsId);
    }

    @DataBoundSetter
    public void setSubscriptionIdVariable(String subscriptionIdVariable) {
        this.subscriptionIdVariable = subscriptionIdVariable;
    }

    @DataBoundSetter
    public void setClientIdVariable(String clientIdVariable) {
        this.clientIdVariable = clientIdVariable;
    }

    @DataBoundSetter
    public void setClientSecretVariable(String clientSecretVariable) {
        this.clientSecretVariable = clientSecretVariable;
    }

    @DataBoundSetter
    public void setTenantIdVariable(String tenantIdVariable) {
        this.tenantIdVariable = tenantIdVariable;
    }

    public String getSubscriptionIdVariable() {
        if (!StringUtils.isBlank((String)this.subscriptionIdVariable)) {
            return this.subscriptionIdVariable;
        }
        return DEFAULT_SUBSCRIPTION_ID_VARIABLE;
    }

    public String getClientIdVariable() {
        if (!StringUtils.isBlank((String)this.clientIdVariable)) {
            return this.clientIdVariable;
        }
        return DEFAULT_CLIENT_ID_VARIABLE;
    }

    public String getClientSecretVariable() {
        if (!StringUtils.isBlank((String)this.clientSecretVariable)) {
            return this.clientSecretVariable;
        }
        return DEFAULT_CLIENT_SECRET_VARIABLE;
    }

    public String getTenantIdVariable() {
        if (!StringUtils.isBlank((String)this.tenantIdVariable)) {
            return this.tenantIdVariable;
        }
        return DEFAULT_TENANT_ID_VARIABLE;
    }

    protected Class<AzureCredentials> type() {
        return AzureCredentials.class;
    }

    public MultiBinding.MultiEnvironment bind(@NonNull Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        AzureCredentials credentials = (AzureCredentials)this.getCredentials(build);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.getSubscriptionIdVariable(), credentials.getSubscriptionId());
        map.put(this.getClientIdVariable(), credentials.getClientId());
        map.put(this.getClientSecretVariable(), credentials.getPlainClientSecret());
        map.put(this.getTenantIdVariable(), credentials.getTenant());
        return new MultiBinding.MultiEnvironment(map);
    }

    public Set<String> variables(Run<?, ?> build) {
        return new HashSet<String>(Arrays.asList(this.getSubscriptionIdVariable(), this.getClientIdVariable(), this.getClientSecretVariable(), this.getTenantIdVariable()));
    }

    @Symbol(value={"azureServicePrincipal"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<AzureCredentials> {
        protected Class<AzureCredentials> type() {
            return AzureCredentials.class;
        }

        public String getDisplayName() {
            return Messages.Azure_Credentials_Binding_Diaplay_Name();
        }

        public boolean requiresWorkspace() {
            return false;
        }

        public String getDefaultSubscriptionIdVariable() {
            return AzureCredentialsBinding.DEFAULT_SUBSCRIPTION_ID_VARIABLE;
        }

        public String getDefaultClientIdVariable() {
            return AzureCredentialsBinding.DEFAULT_CLIENT_ID_VARIABLE;
        }

        public String getDefaultClientSecretVariable() {
            return AzureCredentialsBinding.DEFAULT_CLIENT_SECRET_VARIABLE;
        }

        public String getDefaultTenantIdVariable() {
            return AzureCredentialsBinding.DEFAULT_TENANT_ID_VARIABLE;
        }
    }
}

