// CHECKSTYLE:OFF

package com.microsoft.azure.util;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Azure_MI_Config_Success}: {@code Successfully verified the
     * Managed Identity.}.
     * 
     * @return
     *     {@code Successfully verified the Managed Identity.}
     */
    public static String Azure_MI_Config_Success() {
        return holder.format("Azure_MI_Config_Success");
    }

    /**
     * Key {@code Azure_MI_Config_Success}: {@code Successfully verified the
     * Managed Identity.}.
     * 
     * @return
     *     {@code Successfully verified the Managed Identity.}
     */
    public static Localizable _Azure_MI_Config_Success() {
        return new Localizable(holder, "Azure_MI_Config_Success");
    }

    /**
     * Key {@code Azure_OAuthToken_Missing}: {@code Error: OAuth 2.0 Token
     * Endpoint is missing.}.
     * 
     * @return
     *     {@code Error: OAuth 2.0 Token Endpoint is missing.}
     */
    public static String Azure_OAuthToken_Missing() {
        return holder.format("Azure_OAuthToken_Missing");
    }

    /**
     * Key {@code Azure_OAuthToken_Missing}: {@code Error: OAuth 2.0 Token
     * Endpoint is missing.}.
     * 
     * @return
     *     {@code Error: OAuth 2.0 Token Endpoint is missing.}
     */
    public static Localizable _Azure_OAuthToken_Missing() {
        return new Localizable(holder, "Azure_OAuthToken_Missing");
    }

    /**
     * Key {@code Azure_Invalid_SubscriptionId}: {@code The subscription id
     * is not valid}.
     * 
     * @return
     *     {@code The subscription id is not valid}
     */
    public static String Azure_Invalid_SubscriptionId() {
        return holder.format("Azure_Invalid_SubscriptionId");
    }

    /**
     * Key {@code Azure_Invalid_SubscriptionId}: {@code The subscription id
     * is not valid}.
     * 
     * @return
     *     {@code The subscription id is not valid}
     */
    public static Localizable _Azure_Invalid_SubscriptionId() {
        return new Localizable(holder, "Azure_Invalid_SubscriptionId");
    }

    /**
     * Key {@code Azure_ClientSecret_Missing}: {@code Error: Neither Client
     * Secret nor Certificate is provided.}.
     * 
     * @return
     *     {@code Error: Neither Client Secret nor Certificate is provided.}
     */
    public static String Azure_ClientSecret_Missing() {
        return holder.format("Azure_ClientSecret_Missing");
    }

    /**
     * Key {@code Azure_ClientSecret_Missing}: {@code Error: Neither Client
     * Secret nor Certificate is provided.}.
     * 
     * @return
     *     {@code Error: Neither Client Secret nor Certificate is provided.}
     */
    public static Localizable _Azure_ClientSecret_Missing() {
        return new Localizable(holder, "Azure_ClientSecret_Missing");
    }

    /**
     * Key {@code Azure_ClientCertificate_NotFound}: {@code Error: The
     * selected Certificate was not found.}.
     * 
     * @return
     *     {@code Error: The selected Certificate was not found.}
     */
    public static String Azure_ClientCertificate_NotFound() {
        return holder.format("Azure_ClientCertificate_NotFound");
    }

    /**
     * Key {@code Azure_ClientCertificate_NotFound}: {@code Error: The
     * selected Certificate was not found.}.
     * 
     * @return
     *     {@code Error: The selected Certificate was not found.}
     */
    public static Localizable _Azure_ClientCertificate_NotFound() {
        return new Localizable(holder, "Azure_ClientCertificate_NotFound");
    }

    /**
     * Key {@code Azure_SubscriptionID_Missing}: {@code Error: Subscription
     * ID is missing.}.
     * 
     * @return
     *     {@code Error: Subscription ID is missing.}
     */
    public static String Azure_SubscriptionID_Missing() {
        return holder.format("Azure_SubscriptionID_Missing");
    }

    /**
     * Key {@code Azure_SubscriptionID_Missing}: {@code Error: Subscription
     * ID is missing.}.
     * 
     * @return
     *     {@code Error: Subscription ID is missing.}
     */
    public static Localizable _Azure_SubscriptionID_Missing() {
        return new Localizable(holder, "Azure_SubscriptionID_Missing");
    }

    /**
     * Key {@code Azure_CantValidate}: {@code The provided credentials are
     * not valid}.
     * 
     * @return
     *     {@code The provided credentials are not valid}
     */
    public static String Azure_CantValidate() {
        return holder.format("Azure_CantValidate");
    }

    /**
     * Key {@code Azure_CantValidate}: {@code The provided credentials are
     * not valid}.
     * 
     * @return
     *     {@code The provided credentials are not valid}
     */
    public static Localizable _Azure_CantValidate() {
        return new Localizable(holder, "Azure_CantValidate");
    }

    /**
     * Key {@code Azure_ClientID_Missing}: {@code Error: Client ID is
     * missing.}.
     * 
     * @return
     *     {@code Error: Client ID is missing.}
     */
    public static String Azure_ClientID_Missing() {
        return holder.format("Azure_ClientID_Missing");
    }

    /**
     * Key {@code Azure_ClientID_Missing}: {@code Error: Client ID is
     * missing.}.
     * 
     * @return
     *     {@code Error: Client ID is missing.}
     */
    public static Localizable _Azure_ClientID_Missing() {
        return new Localizable(holder, "Azure_ClientID_Missing");
    }

    /**
     * Key {@code Azure_Credentials_Select}: {@code --- Select a Certificate
     * ---}.
     * 
     * @return
     *     {@code --- Select a Certificate ---}
     */
    public static String Azure_Credentials_Select() {
        return holder.format("Azure_Credentials_Select");
    }

    /**
     * Key {@code Azure_Credentials_Select}: {@code --- Select a Certificate
     * ---}.
     * 
     * @return
     *     {@code --- Select a Certificate ---}
     */
    public static Localizable _Azure_Credentials_Select() {
        return new Localizable(holder, "Azure_Credentials_Select");
    }

    /**
     * Key {@code Azure_Config_Success}: {@code Successfully verified the
     * Azure Service Principal.}.
     * 
     * @return
     *     {@code Successfully verified the Azure Service Principal.}
     */
    public static String Azure_Config_Success() {
        return holder.format("Azure_Config_Success");
    }

    /**
     * Key {@code Azure_Config_Success}: {@code Successfully verified the
     * Azure Service Principal.}.
     * 
     * @return
     *     {@code Successfully verified the Azure Service Principal.}
     */
    public static Localizable _Azure_Config_Success() {
        return new Localizable(holder, "Azure_Config_Success");
    }

    /**
     * Key {@code Azure_OAuthToken_Malformed}: {@code Error: OAuth 2.0 Token
     * Endpoint is malformed.}.
     * 
     * @return
     *     {@code Error: OAuth 2.0 Token Endpoint is malformed.}
     */
    public static String Azure_OAuthToken_Malformed() {
        return holder.format("Azure_OAuthToken_Malformed");
    }

    /**
     * Key {@code Azure_OAuthToken_Malformed}: {@code Error: OAuth 2.0 Token
     * Endpoint is malformed.}.
     * 
     * @return
     *     {@code Error: OAuth 2.0 Token Endpoint is malformed.}
     */
    public static Localizable _Azure_OAuthToken_Malformed() {
        return new Localizable(holder, "Azure_OAuthToken_Malformed");
    }

    /**
     * Key {@code Azure_Credentials_Binding_Diaplay_Name}: {@code Microsoft
     * Azure Service Principal}.
     * 
     * @return
     *     {@code Microsoft Azure Service Principal}
     */
    public static String Azure_Credentials_Binding_Diaplay_Name() {
        return holder.format("Azure_Credentials_Binding_Diaplay_Name");
    }

    /**
     * Key {@code Azure_Credentials_Binding_Diaplay_Name}: {@code Microsoft
     * Azure Service Principal}.
     * 
     * @return
     *     {@code Microsoft Azure Service Principal}
     */
    public static Localizable _Azure_Credentials_Binding_Diaplay_Name() {
        return new Localizable(holder, "Azure_Credentials_Binding_Diaplay_Name");
    }

}
