/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.remote;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.microsoft.jenkins.containeragents.remote.UsernamePasswordAuth;
import com.microsoft.jenkins.containeragents.remote.UsernamePrivateKeyAuth;
import hudson.util.Secret;

abstract class UsernameAuth {
    private final String username;

    UsernameAuth(String username) {
        this.username = username;
    }

    String getUsername() {
        return this.username;
    }

    static UsernameAuth fromCredentials(StandardUsernameCredentials credentials) {
        if (credentials instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials userPass = (StandardUsernamePasswordCredentials)credentials;
            return new UsernamePasswordAuth(userPass.getUsername(), userPass.getPassword().getPlainText());
        }
        if (credentials instanceof SSHUserPrivateKey) {
            SSHUserPrivateKey userKey = (SSHUserPrivateKey)credentials;
            Secret passphraseSecret = userKey.getPassphrase();
            String passphrase = passphraseSecret == null ? null : passphraseSecret.getPlainText();
            return new UsernamePrivateKeyAuth(userKey.getUsername(), passphrase, userKey.getPrivateKeys());
        }
        throw new IllegalArgumentException("Unsupported credentials type " + credentials.getClass().getName());
    }
}

