// CHECKSTYLE:OFF

package com.microsoft.jenkins.containeragents;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Not_Number_Error}: {@code Error: Must be number}.
     * 
     * @return
     *     {@code Error: Must be number}
     */
    public static String Not_Number_Error() {
        return holder.format("Not_Number_Error");
    }

    /**
     * Key {@code Not_Number_Error}: {@code Error: Must be number}.
     * 
     * @return
     *     {@code Error: Must be number}
     */
    public static Localizable _Not_Number_Error() {
        return new Localizable(holder, "Not_Number_Error");
    }

    /**
     * Key {@code Resource_Group_List_Failed}: {@code List resource group
     * failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code List resource group failed: {0}}
     */
    public static String Resource_Group_List_Failed(Object arg0) {
        return holder.format("Resource_Group_List_Failed", arg0);
    }

    /**
     * Key {@code Resource_Group_List_Failed}: {@code List resource group
     * failed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code List resource group failed: {0}}
     */
    public static Localizable _Resource_Group_List_Failed(Object arg0) {
        return new Localizable(holder, "Resource_Group_List_Failed", arg0);
    }

}
