/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.strategy;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class ContainerIdleRetentionStrategy
extends CloudRetentionStrategy {
    private static final Logger LOGGER = Logger.getLogger(ContainerIdleRetentionStrategy.class.getName());
    private int idleMinutes;
    private static final transient int LAPSE = 5;
    @Restricted(value={NoExternalUse.class})
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public ContainerIdleRetentionStrategy(int idleMinutes) {
        super(idleMinutes);
        this.idleMinutes = idleMinutes;
    }

    @GuardedBy(value="hudson.model.Queue.lock")
    public long check(AbstractCloudComputer c) {
        AbstractCloudSlave computerNode = c.getNode();
        if (c.isIdle() && !disabled && computerNode != null) {
            long milliBetweenCreationAndIdle = c.getIdleStartMilliseconds() - c.getConnectTime();
            boolean neverConnected = milliBetweenCreationAndIdle < TimeUnit.SECONDS.toMillis(5L);
            Computer computer = Jenkins.get().toComputer();
            if (computer == null) {
                return 1L;
            }
            if (c.getIdleStartMilliseconds() - computer.getConnectTime() < TimeUnit.SECONDS.toMillis(5L)) {
                neverConnected = false;
            }
            long idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds();
            if (this.idleMinutes != 0 && !neverConnected && idleMilliseconds > TimeUnit.MINUTES.toMillis(this.idleMinutes)) {
                LOGGER.log(Level.INFO, "Disconnecting {0}", c.getName());
                try {
                    computerNode.terminate();
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Failed to terminate " + c.getName(), e);
                }
            }
        }
        return 1L;
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        @NonNull
        public String getDisplayName() {
            return "Container Idle Retention Strategy";
        }
    }
}

