/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.remote;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.microsoft.jenkins.containeragents.remote.UsernameAuth;
import com.microsoft.jenkins.containeragents.remote.UsernamePasswordAuth;
import com.microsoft.jenkins.containeragents.remote.UsernamePrivateKeyAuth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class SSHClient
implements AutoCloseable {
    private static final int READ_BUFFER_SIZE = 4096;
    private final String host;
    private final int port;
    private final UsernameAuth credentials;
    private final JSch jsch;
    private Session session;
    private PrintStream logger;

    public SSHClient(String host, int port, String username, String password) throws JSchException {
        this(host, port, new UsernamePasswordAuth(username, password));
    }

    public SSHClient(String host, int port, String username, Secret passPhrase, String ... privateKeys) throws JSchException {
        this(host, port, new UsernamePrivateKeyAuth(username, passPhrase == null ? null : passPhrase.getPlainText(), privateKeys));
    }

    public SSHClient(String host, int port, StandardUsernameCredentials credentials) throws JSchException {
        this(host, port, UsernameAuth.fromCredentials(credentials));
    }

    public SSHClient(String host, int port, UsernameAuth auth) throws JSchException {
        this.host = host;
        this.port = port;
        this.jsch = new JSch();
        this.credentials = auth;
        if (auth instanceof UsernamePrivateKeyAuth) {
            UsernamePrivateKeyAuth userPrivateKey = (UsernamePrivateKeyAuth)auth;
            byte[] passphraseBytes = userPrivateKey.getPassPhraseBytes();
            int seq = 0;
            for (String privateKey : userPrivateKey.getPrivateKeys()) {
                Object name = auth.getUsername();
                if (seq++ != 0) {
                    name = (String)name + "-" + seq;
                }
                this.jsch.addIdentity((String)name, privateKey.getBytes(StandardCharsets.UTF_8), null, passphraseBytes);
            }
        }
    }

    public SSHClient withLogger(PrintStream log) {
        this.logger = log;
        return this;
    }

    public SSHClient connect() throws JSchException {
        if (this.session != null && this.session.isConnected()) {
            throw new JSchException("SSH session is already connected, close previous session first.");
        }
        this.session = this.jsch.getSession(this.credentials.getUsername(), this.host, this.port);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        UsernameAuth usernameAuth = this.credentials;
        if (usernameAuth instanceof UsernamePasswordAuth) {
            UsernamePasswordAuth usernamePasswordAuth = (UsernamePasswordAuth)usernameAuth;
            this.session.setPassword(usernamePasswordAuth.getPassword());
        }
        this.session.connect();
        return this;
    }

    public void copyTo(File sourceFile, String remotePath) throws JSchException {
        this.log("copy file {0} to {1}:{2}", sourceFile, this.host, remotePath);
        this.withChannelSftp(channel -> channel.put(sourceFile.getAbsolutePath(), remotePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(InputStream in, String remotePath) throws JSchException {
        try {
            this.withChannelSftp(channel -> channel.put(in, remotePath));
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException e) {
                this.log("Failed to close input stream: {0}", e.getMessage());
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            this.log("Failed to close input stream: {0}", e.getMessage());
        }
    }

    public void copyFrom(String remotePath, File destFile) throws JSchException {
        this.log("copy file {0}:{1} to {2}", this.host, remotePath, destFile);
        this.withChannelSftp(channel -> channel.get(remotePath, destFile.getAbsolutePath()));
    }

    public void copyFrom(String remotePath, OutputStream out) throws JSchException {
        this.withChannelSftp(channel -> channel.get(remotePath, out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withChannelSftp(ChannelSftpConsumer consumer) throws JSchException {
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)this.session.openChannel("sftp");
            channel.connect();
            try {
                consumer.apply(channel);
            }
            catch (SftpException e) {
                throw new JSchException("sftp error", (Throwable)e);
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    public String execRemote(String command) throws JSchException, IOException, ExitStatusException {
        return this.execRemote(command, true, true);
    }

    public String execRemote(String command, boolean showCommand, boolean capture) throws JSchException, IOException, ExitStatusException {
        ChannelExec channel = null;
        try {
            channel = (ChannelExec)this.session.openChannel("exec");
            channel.setCommand(command);
            if (showCommand) {
                this.log("===> exec: {0}", command);
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            if (this.logger != null) {
                channel.setErrStream((OutputStream)this.logger, true);
                if (!capture) {
                    channel.setOutputStream((OutputStream)this.logger, true);
                }
            }
            channel.connect();
            if (!capture) {
                while (!channel.isClosed()) {
                    try {
                        int waitPeriod = 200;
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new JSchException("", (Throwable)e);
                    }
                }
                int exitCode = channel.getExitStatus();
                this.log("<=== command exit status: {0}", exitCode);
                if (exitCode != 0) {
                    throw new ExitStatusException(exitCode, "");
                }
                String string = "";
                return string;
            }
            InputStream in = channel.getInputStream();
            while (true) {
                int len;
                if ((len = in.read(buffer, 0, buffer.length)) >= 0) {
                    output.write(buffer, 0, len);
                    if (in.available() > 0) continue;
                }
                if (channel.isClosed() && in.available() <= 0) break;
            }
            int exitCode = channel.getExitStatus();
            this.log("<=== command exit status: {0}", exitCode);
            String serverOutput = output.toString(StandardCharsets.UTF_8);
            this.log("<=== {0}", serverOutput);
            if (exitCode != 0) {
                throw new ExitStatusException(exitCode, serverOutput);
            }
            String string = serverOutput;
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to execute command", e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    public SSHClient forwardSSH(String remoteHost, int remotePort) throws JSchException {
        return this.forwardSSH(remoteHost, remotePort, this.credentials);
    }

    public SSHClient forwardSSH(String remoteHost, int remotePort, UsernameAuth sshCredentials) throws JSchException {
        int localPort = this.session.setPortForwardingL(0, remoteHost, remotePort);
        return new SSHClient("127.0.0.1", localPort, sshCredentials).withLogger(this.logger);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.credentials.getUsername();
    }

    public UsernameAuth getCredentials() {
        return this.credentials;
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    @SuppressFBWarnings
    private void log(String message) {
        if (this.logger != null) {
            this.logger.println(message);
        }
    }

    private void log(String message, Object ... args) {
        if (this.logger != null) {
            this.logger.printf(message + "%n", args);
        }
    }

    private static interface ChannelSftpConsumer {
        public void apply(ChannelSftp var1) throws SftpException;
    }

    public static class ExitStatusException
    extends Exception {
        private final int exitStatus;
        private final String output;

        public ExitStatusException(int exitStatus, String output) {
            super(String.format("Command exited with code: %d", exitStatus));
            this.exitStatus = exitStatus;
            this.output = output;
        }

        public int getExitStatus() {
            return this.exitStatus;
        }

        public String getOutput() {
            return this.output;
        }
    }
}

