/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.aci;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.microsoft.jenkins.containeragents.aci.AciCloud;
import com.microsoft.jenkins.containeragents.aci.AciComputer;
import com.microsoft.jenkins.containeragents.aci.AciContainerTemplate;
import com.microsoft.jenkins.containeragents.aci.AciService;
import com.microsoft.jenkins.containeragents.remote.ISSHLaunchable;
import com.microsoft.jenkins.containeragents.remote.SSHLauncher;
import com.microsoft.jenkins.containeragents.util.AzureContainerUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public class AciAgent
extends AbstractCloudSlave
implements ISSHLaunchable,
TrackedItem {
    private static final Logger LOGGER = Logger.getLogger(AciAgent.class.getName());
    private final String credentialsId;
    private final String cloudName;
    private final String resourceGroup;
    private String deployName = null;
    private final String sshCredentialsId;
    private final String sshPort;
    private final String launchType;
    private String host;
    private final ProvisioningActivity.Id provisioningId;

    @DataBoundConstructor
    public AciAgent(AciCloud cloud, AciContainerTemplate template) throws Descriptor.FormException, IOException {
        super(AciAgent.generateAgentName(template), template.getRootFs(), (ComputerLauncher)(template.getLaunchMethodType().equals("jnlp") ? new JNLPLauncher() : new SSHLauncher()));
        this.setLabelString(template.getLabel());
        this.setRetentionStrategy(template.getRetentionStrategy());
        this.credentialsId = cloud.getCredentialsId();
        this.cloudName = cloud.getName();
        this.resourceGroup = cloud.getResourceGroup();
        this.sshCredentialsId = template.getSshCredentialsId();
        this.sshPort = template.getSshPort();
        this.launchType = template.getLaunchMethodType();
        this.provisioningId = new ProvisioningActivity.Id(cloud.name, template.getName(), this.getNodeName());
    }

    public AciComputer createComputer() {
        return new AciComputer(this);
    }

    protected void _terminate(TaskListener listener) {
        Computer computer = this.toComputer();
        if (computer == null || StringUtils.isEmpty((CharSequence)this.cloudName)) {
            return;
        }
        Cloud cloud = Jenkins.get().getCloud(this.cloudName);
        if (cloud == null) {
            return;
        }
        if (!(cloud instanceof AciCloud)) {
            String msg = String.format("Cloud %s is not a AciCloud", this.cloudName);
            LOGGER.log(Level.WARNING, msg);
            listener.fatalError(msg);
            return;
        }
        Computer.threadPoolForRemoting.execute(() -> AciService.deleteAciContainerGroup(this.credentialsId, this.resourceGroup, this.getNodeName(), this.deployName));
    }

    static String generateAgentName(AciContainerTemplate template) {
        return AzureContainerUtils.generateName(template.getName(), 5);
    }

    @DataBoundSetter
    public void setDeployName(String deployName) {
        this.deployName = deployName;
    }

    public String getDeployName() {
        return this.deployName;
    }

    public Node reconfigure(@NonNull StaplerRequest2 req, JSONObject form) {
        return this;
    }

    @Override
    public StandardUsernameCredentials getSshCredential() throws IllegalArgumentException {
        StandardUsernameCredentials credentials = (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(StandardUsernameCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.sshCredentialsId));
        if (credentials == null) {
            throw new IllegalArgumentException("Could not find credentials with id: " + this.sshCredentialsId);
        }
        return credentials;
    }

    @Override
    public int getSshPort() {
        return Integer.parseInt(this.sshPort);
    }

    @Override
    public boolean isSshLaunchType() {
        return this.launchType.equals("ssh");
    }

    @Override
    public String getHost() {
        return StringUtils.defaultString((String)this.host);
    }

    public void setHost(String host) {
        this.host = host;
    }

    @NonNull
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Aci Agent";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

