/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.strategy;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProvisionRetryStrategy {
    private static final int MAX_INTERVAL = 600000;
    private Map<String, Record> records = new ConcurrentHashMap<String, Record>();

    public synchronized void failure(String name) {
        Record record = this.records.get(name);
        if (record == null) {
            record = new Record();
            this.records.put(name, record);
        } else {
            int nextInterval = record.getInterval();
            nextInterval = Math.min(nextInterval * 2, 600000);
            record.setInterval(nextInterval);
        }
        record.setLastFail(System.currentTimeMillis());
    }

    public synchronized void success(String name) {
        this.records.remove(name);
    }

    public long getNextRetryTime(String name) {
        Record record = this.records.get(name);
        if (record == null) {
            return 0L;
        }
        return record.getLastFail() + (long)record.getInterval();
    }

    public boolean isEnabled(String name) {
        return this.isEnabled(name, System.currentTimeMillis());
    }

    public boolean isEnabled(String name, long now) {
        return now >= this.getNextRetryTime(name);
    }

    Map<String, Record> getRecords() {
        return this.records;
    }

    public static class Record {
        private static final int INITIAL_INTERVAL = 5000;
        private long lastFail;
        private int interval = 5000;

        public long getLastFail() {
            return this.lastFail;
        }

        public void setLastFail(long lastFail) {
            this.lastFail = lastFail;
        }

        public int getInterval() {
            return this.interval;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }
    }
}

