/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.aci.dns;

import com.microsoft.jenkins.containeragents.aci.dns.AciDnsServer;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AciDnsConfig
extends AbstractDescribableImpl<AciDnsConfig> {
    private List<AciDnsServer> dnsServers = new ArrayList<AciDnsServer>();

    @DataBoundConstructor
    public AciDnsConfig() {
    }

    public List<AciDnsServer> getDnsServers() {
        return this.dnsServers;
    }

    @DataBoundSetter
    public void setDnsServers(List<AciDnsServer> dnsServers) {
        this.dnsServers = dnsServers.stream().filter(aciDnsServer -> !aciDnsServer.getAddress().isEmpty()).collect(Collectors.toList());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AciDnsConfig> {
        @NonNull
        public String getDisplayName() {
            return "Aci DNS Config";
        }
    }
}

