/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.strategy;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.EphemeralNode;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class ContainerOnceRetentionStrategy
extends CloudRetentionStrategy
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(ContainerOnceRetentionStrategy.class.getName());
    private static final transient int IDLE_MINUTES = 10;
    private static final transient int WAIT_TIME = 10000;
    private static final transient int LAPSE = 5;
    @Restricted(value={NoExternalUse.class})
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public ContainerOnceRetentionStrategy() {
        super(10);
    }

    public int getIdleMinutes() {
        return 10;
    }

    public long check(AbstractCloudComputer c) {
        if (c.isIdle() && !disabled) {
            long milliBetweenCreationAndIdle = c.getIdleStartMilliseconds() - c.getConnectTime();
            boolean neverConnected = milliBetweenCreationAndIdle < TimeUnit.SECONDS.toMillis(5L);
            Computer computer = Jenkins.get().toComputer();
            if (computer == null) {
                return 1L;
            }
            if (c.getIdleStartMilliseconds() - computer.getConnectTime() < TimeUnit.SECONDS.toMillis(5L)) {
                neverConnected = false;
            }
            long idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds();
            if (!neverConnected && idleMilliseconds > TimeUnit.MINUTES.toMillis(10L)) {
                LOGGER.log(Level.INFO, "Disconnecting {0}", c.getName());
                this.done(c);
            }
        }
        return 1L;
    }

    public void start(AbstractCloudComputer c) {
        if (c.getNode() instanceof EphemeralNode) {
            throw new IllegalStateException("May not use OnceRetentionStrategy on an EphemeralNode: " + String.valueOf(c));
        }
        super.start(c);
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.done(executor);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.done(executor);
    }

    private void done(Executor executor) {
        try {
            Thread.sleep(10000L);
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        AbstractCloudComputer c = (AbstractCloudComputer)executor.getOwner();
        Queue.Executable exec = executor.getCurrentExecutable();
        LOGGER.log(Level.INFO, "terminating {0} since {1} seems to be finished", new Object[]{c.getName(), exec});
        this.done(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done(AbstractCloudComputer<?> c) {
        c.setAcceptingTasks(false);
        ContainerOnceRetentionStrategy containerOnceRetentionStrategy = this;
        synchronized (containerOnceRetentionStrategy) {
            Computer.threadPoolForRemoting.submit(() -> Queue.withLock(() -> {
                try {
                    AbstractCloudSlave node = c.getNode();
                    if (node != null) {
                        node.terminate();
                    }
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Failed to terminate {0}: {1}", new Object[]{c.getName(), e});
                }
            }));
        }
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        @NonNull
        public String getDisplayName() {
            return "Container Once Retention Strategy";
        }
    }
}

