/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.aci;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.containerinstance.models.ContainerGroup;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.DeploymentMode;
import com.azure.resourcemanager.resources.models.Deployments;
import com.microsoft.jenkins.containeragents.aci.AciAgent;
import com.microsoft.jenkins.containeragents.aci.AciCleanTask;
import com.microsoft.jenkins.containeragents.aci.AciCloud;
import com.microsoft.jenkins.containeragents.aci.AciContainerTemplate;
import com.microsoft.jenkins.containeragents.builders.AciDeploymentTemplateBuilder;
import com.microsoft.jenkins.containeragents.util.AzureContainerUtils;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.StopWatch;

public final class AciService {
    private static final Logger LOGGER = Logger.getLogger(AciService.class.getName());

    private AciService() {
    }

    public static void createDeployment(AciCloud cloud, AciContainerTemplate template, AciAgent agent, StopWatch stopWatch) throws Exception {
        String deployName = AciService.getDeploymentName(template);
        AciDeploymentTemplateBuilder.AciDeploymentTemplate deploymentTemplate = new AciDeploymentTemplateBuilder().buildDeploymentTemplate(cloud, template, agent);
        AciCleanTask.DeploymentRegistrar deploymentRegistrar = AciCleanTask.DeploymentRegistrar.getInstance();
        deploymentRegistrar.registerDeployment(cloud.getName(), cloud.getResourceGroup(), deployName);
        String armTemplateForDeployment = deploymentTemplate.deploymentTemplateAsString();
        LOGGER.log(Level.FINE, "Deployment ARM Template: {0}", armTemplateForDeployment);
        String armTemplateParameterForDeployment = deploymentTemplate.templateParameterAsString();
        LOGGER.log(Level.FINE, "Deployment ARM Template Parameter: {0}", armTemplateParameterForDeployment);
        AzureResourceManager azureClient = cloud.getAzureClient();
        ((Deployment.DefinitionStages.WithTemplate)((Deployment.DefinitionStages.Blank)azureClient.deployments().define(deployName)).withExistingResourceGroup(cloud.getResourceGroup())).withTemplate(armTemplateForDeployment).withParameters(armTemplateParameterForDeployment).withMode(DeploymentMode.INCREMENTAL).beginCreate();
        agent.setDeployName(deployName);
        int retryInterval = 10000;
        LOGGER.log(Level.INFO, "Waiting for deployment {0}", deployName);
        while (true) {
            ContainerGroup containerGroup;
            if (AzureContainerUtils.isTimeout(template.getTimeout(), stopWatch.getTime())) {
                throw new TimeoutException("Deployment timeout");
            }
            Deployment deployment = (Deployment)azureClient.deployments().getByResourceGroup(cloud.getResourceGroup(), deployName);
            if (deployment.provisioningState().equalsIgnoreCase("succeeded")) break;
            if (deployment.provisioningState().equalsIgnoreCase("Failed")) {
                throw new Exception(String.format("Deployment %s status: Failed", deployName));
            }
            if (AzureContainerUtils.isHalfTimePassed(template.getTimeout(), stopWatch.getTime()) && (containerGroup = (ContainerGroup)azureClient.containerGroups().getByResourceGroup(cloud.getResourceGroup(), agent.getNodeName())) != null) {
                LOGGER.log(Level.INFO, "Logs from container {0}: {1}", new Object[]{agent.getNodeName(), containerGroup.getLogContent(agent.getNodeName())});
            }
            Thread.sleep(10000L);
        }
        LOGGER.log(Level.INFO, "Deployment {0} succeed", deployName);
    }

    private static String getDeploymentName(AciContainerTemplate template) {
        return AzureContainerUtils.generateName(template.getName(), 8);
    }

    public static void deleteAciContainerGroup(String credentialsId, String resourceGroup, String containerGroupName, String deployName) {
        AzureResourceManager azureClient;
        try {
            azureClient = AzureContainerUtils.getAzureClient(credentialsId);
            azureClient.containerGroups().deleteByResourceGroup(resourceGroup, containerGroupName);
            LOGGER.log(Level.INFO, "Delete ACI Container Group: {0} successfully", containerGroupName);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Delete ACI Container Group: %s failed", containerGroupName), e);
            return;
        }
        try {
            if (deployName != null) {
                Deployments deployments = azureClient.deployments();
                Deployment deployment = (Deployment)deployments.getByResourceGroup(resourceGroup, deployName);
                if (deployment != null) {
                    String provisioningState = deployment.provisioningState();
                    LOGGER.fine(() -> String.format("Checking deployment: %s, provisioning state: %s", deployName, provisioningState));
                    if (provisioningState.equalsIgnoreCase("succeeded")) {
                        deployments.deleteByResourceGroup(resourceGroup, deployName);
                        LOGGER.log(Level.INFO, "Delete ACI deployment: {0} successfully", deployName);
                    }
                } else {
                    LOGGER.fine(() -> String.format("Skipped deployment: %s as we couldn't find it", deployName));
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Delete ACI deployment: %s failed", deployName), e);
        }
    }
}

