/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.remote;

import com.microsoft.jenkins.containeragents.remote.UsernameAuth;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class UsernamePrivateKeyAuth
extends UsernameAuth {
    private final String passPhrase;
    private final List<String> privateKeys;

    UsernamePrivateKeyAuth(String username, String passPhrase, String ... privateKeys) {
        this(username, passPhrase, Arrays.asList(privateKeys));
    }

    UsernamePrivateKeyAuth(String username, String passPhrase, Iterable<String> privateKeys) {
        super(username);
        this.passPhrase = passPhrase;
        ArrayList<String> privateKeyList = new ArrayList<String>();
        for (String privateKey : privateKeys) {
            privateKeyList.add(privateKey);
        }
        this.privateKeys = Collections.unmodifiableList(privateKeyList);
    }

    byte[] getPassPhraseBytes() {
        if (this.passPhrase == null) {
            return null;
        }
        return this.passPhrase.getBytes(StandardCharsets.UTF_8);
    }

    List<String> getPrivateKeys() {
        return this.privateKeys;
    }
}

