/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.aci;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.microsoft.jenkins.containeragents.Messages;
import com.microsoft.jenkins.containeragents.PodEnvVar;
import com.microsoft.jenkins.containeragents.aci.AciAgent;
import com.microsoft.jenkins.containeragents.aci.AciCloud;
import com.microsoft.jenkins.containeragents.aci.AciPort;
import com.microsoft.jenkins.containeragents.aci.AciPrivateIpAddress;
import com.microsoft.jenkins.containeragents.aci.AciService;
import com.microsoft.jenkins.containeragents.aci.volumes.AzureFileVolume;
import com.microsoft.jenkins.containeragents.remote.LaunchMethodTypeContent;
import com.microsoft.jenkins.containeragents.strategy.ContainerIdleRetentionStrategy;
import com.microsoft.jenkins.containeragents.strategy.ContainerOnceRetentionStrategy;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.labels.LabelAtom;
import hudson.security.ACL;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AciContainerTemplate
extends AbstractDescribableImpl<AciContainerTemplate> {
    private static final Logger LOGGER = Logger.getLogger(AciContainerTemplate.class.getName());
    private String name;
    private String label;
    private String image;
    private String osType;
    private String command;
    private String rootFs;
    private AciPrivateIpAddress privateIpAddress;
    private int timeout;
    private List<AciPort> ports;
    private String cpu;
    private String memory;
    private RetentionStrategy<?> retentionStrategy;
    private List<PodEnvVar> envVars;
    private List<DockerRegistryEndpoint> privateRegistryCredentials;
    private List<AzureFileVolume> volumes;
    private String launchMethodType;
    private String sshCredentialsId;
    private String sshPort;
    private boolean isAvailable = true;

    @DataBoundConstructor
    public AciContainerTemplate(String name, String label, int timeout, String osType, String image, String command, String rootFs, List<AciPort> ports, List<DockerRegistryEndpoint> privateRegistryCredentials, List<PodEnvVar> envVars, List<AzureFileVolume> volumes, RetentionStrategy<?> retentionStrategy, String cpu, String memory) {
        this.name = name;
        this.label = label;
        this.image = image.trim();
        this.osType = osType;
        this.command = command;
        this.rootFs = rootFs;
        this.ports = Objects.requireNonNullElseGet(ports, ArrayList::new);
        this.cpu = cpu;
        this.memory = memory;
        this.timeout = timeout;
        this.retentionStrategy = retentionStrategy;
        this.envVars = Objects.requireNonNullElseGet(envVars, ArrayList::new);
        this.privateRegistryCredentials = Objects.requireNonNullElseGet(privateRegistryCredentials, ArrayList::new);
        this.volumes = Objects.requireNonNullElseGet(volumes, ArrayList::new);
        this.setAvailable(true);
    }

    public void provisionAgents(AciCloud cloud, AciAgent agent, StopWatch stopWatch) throws Exception {
        AciService.createDeployment(cloud, this, agent, stopWatch);
    }

    public boolean isJnlp() {
        return StringUtils.isBlank((CharSequence)this.launchMethodType) || this.launchMethodType.equals("jnlp");
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public Set<LabelAtom> getLabelSet() {
        return Label.parse((String)this.label);
    }

    public String getImage() {
        return this.image;
    }

    public String getOsType() {
        return this.osType;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getCommand() {
        return this.command;
    }

    public String getRootFs() {
        return this.rootFs;
    }

    public List<AciPort> getPorts() {
        return this.ports;
    }

    public String getCpu() {
        return this.cpu;
    }

    public String getMemory() {
        return this.memory;
    }

    public RetentionStrategy<?> getRetentionStrategy() {
        return this.retentionStrategy;
    }

    public List<PodEnvVar> getEnvVars() {
        return this.envVars;
    }

    public List<DockerRegistryEndpoint> getPrivateRegistryCredentials() {
        return this.privateRegistryCredentials;
    }

    public List<AzureFileVolume> getVolumes() {
        return this.volumes;
    }

    public void setAvailable(boolean available) {
        this.isAvailable = available;
    }

    public boolean getAvailable() {
        return this.isAvailable;
    }

    public String getLaunchMethodType() {
        return StringUtils.defaultString((String)this.launchMethodType, (String)"jnlp");
    }

    @DataBoundSetter
    public void setLaunchMethodType(String launchMethodType) {
        this.launchMethodType = StringUtils.defaultString((String)launchMethodType, (String)"jnlp");
    }

    public String getSshCredentialsId() {
        return StringUtils.defaultString((String)this.sshCredentialsId);
    }

    public String getSshPort() {
        return StringUtils.defaultString((String)this.sshPort);
    }

    @DataBoundSetter
    public void setLaunchMethodTypeContent(LaunchMethodTypeContent launchMethodTypeContent) {
        if (launchMethodTypeContent != null) {
            this.sshCredentialsId = StringUtils.defaultString((String)launchMethodTypeContent.getSshCredentialsId());
            this.sshPort = StringUtils.defaultString((String)launchMethodTypeContent.getSshPort(), (String)"22");
        }
    }

    public LaunchMethodTypeContent getLaunchMethodTypeContent() {
        return new LaunchMethodTypeContent(this.sshCredentialsId, this.sshPort);
    }

    public AciPrivateIpAddress getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    @DataBoundSetter
    public void setPrivateIpAddress(AciPrivateIpAddress privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AciContainerTemplate> {
        @NonNull
        public String getDisplayName() {
            return "Aci Container Template";
        }

        public List<Descriptor<RetentionStrategy<?>>> getAciRetentionStrategyDescriptors() {
            ArrayList list = new ArrayList();
            list.add(ContainerOnceRetentionStrategy.DESCRIPTOR);
            list.add(ContainerIdleRetentionStrategy.DESCRIPTOR);
            return list;
        }

        public ListBoxModel doFillOsTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Linux");
            model.add("Windows");
            return model;
        }

        public ListBoxModel doFillLaunchMethodTypeItems() {
            return null;
        }

        public ListBoxModel doFillSshCredentialsIdItems(@AncestorInPath Item owner) {
            StandardListBoxModel listBoxModel = new StandardListBoxModel();
            listBoxModel.add("--- Select Azure Container Service Credentials ---", "");
            listBoxModel.includeAs(ACL.SYSTEM2, owner, StandardUsernameCredentials.class, Collections.emptyList());
            return listBoxModel;
        }

        public FormValidation doCheckSshPort(@QueryParameter String value) {
            if (StringUtils.isBlank((CharSequence)value) || value.matches("^[0-9]*$") && Integer.parseInt(value) >= 0 && Integer.parseInt(value) <= 65535) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.Not_Number_Error());
        }
    }
}

