/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.builders;

import com.microsoft.jenkins.containeragents.PodEnvVar;
import com.microsoft.jenkins.containeragents.aci.AciPort;
import com.microsoft.jenkins.containeragents.aci.AciPrivateIpAddress;
import com.microsoft.jenkins.containeragents.aci.volumes.AzureFileVolume;
import com.microsoft.jenkins.containeragents.strategy.ContainerIdleRetentionStrategy;
import com.microsoft.jenkins.containeragents.strategy.ContainerOnceRetentionStrategy;
import hudson.slaves.RetentionStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;

public class AciContainerTemplateFluent<T extends AciContainerTemplateFluent<T>> {
    private String name;
    private String label;
    private String image = "jenkins/inbound-agent";
    private String osType = "Linux";
    private String command = "jenkins-agent -url ${rootUrl} ${secret} ${nodeName}";
    private String rootFs = "/home/jenkins";
    private AciPrivateIpAddress privateIpAddress;
    private int timeout = 10;
    private List<AciPort> ports = new ArrayList<AciPort>();
    private String cpu = "1";
    private String memory = "1.5";
    private RetentionStrategy<?> retentionStrategy;
    private List<PodEnvVar> envVars = new ArrayList<PodEnvVar>();
    private List<DockerRegistryEndpoint> privateRegistryCredentials = new ArrayList<DockerRegistryEndpoint>();
    private List<AzureFileVolume> volumes = new ArrayList<AzureFileVolume>();
    private String launchMethodType = "jnlp";
    private String sshCredentialsId;
    private String sshPort;

    AciContainerTemplateFluent() {
        this.retentionStrategy = new ContainerOnceRetentionStrategy();
    }

    public T withPrivateIpAddress(AciPrivateIpAddress privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return (T)this;
    }

    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    public T withLabel(String label) {
        this.label = label;
        return (T)this;
    }

    public T withImage(String image) {
        this.image = image;
        return (T)this;
    }

    public T withOsType(String osType) {
        this.osType = osType;
        return (T)this;
    }

    public T withCommand(String command) {
        this.command = command;
        return (T)this;
    }

    public T withRootFs(String rootFs) {
        this.rootFs = rootFs;
        return (T)this;
    }

    public T withTimeout(int timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public T withPorts(List<AciPort> ports) {
        this.ports.clear();
        this.ports.addAll(ports);
        return (T)this;
    }

    public T addToPorts(AciPort ... ports) {
        this.ports.addAll(Arrays.asList(ports));
        return (T)this;
    }

    public T addNewPort(String port) {
        this.ports.add(new AciPort(port));
        return (T)this;
    }

    public T withCpu(String cpu) {
        this.cpu = cpu;
        return (T)this;
    }

    public T withMemory(String memory) {
        this.memory = memory;
        return (T)this;
    }

    public T withOnceRetentionStrategy() {
        this.retentionStrategy = new ContainerOnceRetentionStrategy();
        return (T)this;
    }

    public T withIdleRetentionStrategy(int idle) {
        this.retentionStrategy = new ContainerIdleRetentionStrategy(idle);
        return (T)this;
    }

    public T withEnvVars(List<PodEnvVar> envVars) {
        this.envVars.clear();
        this.envVars.addAll(envVars);
        return (T)this;
    }

    public T addToEnvVars(PodEnvVar ... envVars) {
        this.envVars.addAll(Arrays.asList(envVars));
        return (T)this;
    }

    public T addNewEnvVar(String key, String value) {
        this.envVars.add(new PodEnvVar(key, value));
        return (T)this;
    }

    public T withPrivateRegistryCredentials(List<DockerRegistryEndpoint> privateRegistryCredentials) {
        this.privateRegistryCredentials.clear();
        this.privateRegistryCredentials.addAll(privateRegistryCredentials);
        return (T)this;
    }

    public T addToPrivateRegistryCredentials(DockerRegistryEndpoint ... privateRegistryCredentials) {
        this.privateRegistryCredentials.addAll(Arrays.asList(privateRegistryCredentials));
        return (T)this;
    }

    public T addNewPrivateRegistryCredential(String registryUrl, String credentialsId) {
        this.privateRegistryCredentials.add(new DockerRegistryEndpoint(registryUrl, credentialsId));
        return (T)this;
    }

    public T withVolume(List<AzureFileVolume> volumes) {
        this.volumes.clear();
        this.volumes.addAll(volumes);
        return (T)this;
    }

    public T addToVolumes(AzureFileVolume ... volumes) {
        this.volumes.addAll(Arrays.asList(volumes));
        return (T)this;
    }

    public T addNewAzureFileVolume(String mountPath, String shareName, String credentialsId) {
        this.volumes.add(new AzureFileVolume(mountPath, shareName, credentialsId));
        return (T)this;
    }

    public T withJNLPLaunchMethod() {
        this.launchMethodType = "jnlp";
        return (T)this;
    }

    public T withSSHLaunchMethod(String sshCredentialsId, String sshPort) {
        this.launchMethodType = "ssh";
        this.sshCredentialsId = sshCredentialsId;
        this.sshPort = sshPort;
        return (T)this;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getImage() {
        return this.image;
    }

    public String getOsType() {
        return this.osType;
    }

    public String getCommand() {
        return this.command;
    }

    public String getRootFs() {
        return this.rootFs;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public List<AciPort> getPorts() {
        return this.ports;
    }

    public String getCpu() {
        return this.cpu;
    }

    public String getMemory() {
        return this.memory;
    }

    public RetentionStrategy<?> getRetentionStrategy() {
        return this.retentionStrategy;
    }

    public List<PodEnvVar> getEnvVars() {
        return this.envVars;
    }

    public List<DockerRegistryEndpoint> getPrivateRegistryCredentials() {
        return this.privateRegistryCredentials;
    }

    public List<AzureFileVolume> getVolumes() {
        return this.volumes;
    }

    public String getLaunchMethodType() {
        return this.launchMethodType;
    }

    public String getSshCredentialsId() {
        return this.sshCredentialsId;
    }

    public String getSshPort() {
        return this.sshPort;
    }

    public AciPrivateIpAddress getPrivateIpAddress() {
        return this.privateIpAddress;
    }
}

