/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.containeragents.builders;

import com.microsoft.jenkins.containeragents.aci.AciContainerTemplate;
import com.microsoft.jenkins.containeragents.builders.AciContainerTemplateFluent;
import com.microsoft.jenkins.containeragents.remote.LaunchMethodTypeContent;
import com.microsoft.jenkins.containeragents.strategy.ContainerIdleRetentionStrategy;
import hudson.slaves.RetentionStrategy;

public class AciContainerTemplateBuilder
extends AciContainerTemplateFluent<AciContainerTemplateBuilder> {
    private AciContainerTemplateFluent<?> fluent;

    public AciContainerTemplateBuilder() {
        this.fluent = this;
    }

    public AciContainerTemplateBuilder(AciContainerTemplate template) {
        this.fluent = this;
        this.fluent.withName(template.getName());
        this.fluent.withLabel(template.getLabel());
        this.fluent.withImage(template.getImage());
        this.fluent.withOsType(template.getOsType());
        this.fluent.withPrivateIpAddress(template.getPrivateIpAddress());
        this.fluent.withCommand(template.getCommand());
        this.fluent.withRootFs(template.getRootFs());
        this.fluent.withTimeout(template.getTimeout());
        this.fluent.withPorts(template.getPorts());
        this.fluent.withCpu(template.getCpu());
        this.fluent.withMemory(template.getMemory());
        RetentionStrategy<?> retentionStrategy = template.getRetentionStrategy();
        if (retentionStrategy instanceof ContainerIdleRetentionStrategy) {
            ContainerIdleRetentionStrategy strategy = (ContainerIdleRetentionStrategy)retentionStrategy;
            this.fluent.withIdleRetentionStrategy(strategy.getIdleMinutes());
        } else {
            this.fluent.withOnceRetentionStrategy();
        }
        this.fluent.withEnvVars(template.getEnvVars());
        this.fluent.withPrivateRegistryCredentials(template.getPrivateRegistryCredentials());
        this.fluent.withVolume(template.getVolumes());
        if (template.getLaunchMethodType().equals("jnlp")) {
            this.fluent.withJNLPLaunchMethod();
        } else {
            this.fluent.withSSHLaunchMethod(template.getSshCredentialsId(), template.getSshPort());
        }
    }

    public AciContainerTemplateBuilder(AciContainerTemplateFluent<?> fluent) {
        this.fluent = fluent;
    }

    public AciContainerTemplateBuilder(AciContainerTemplateFluent<?> fluent, AciContainerTemplate template) {
        this.fluent = fluent;
        this.fluent.withName(template.getName());
        this.fluent.withLabel(template.getLabel());
        this.fluent.withImage(template.getImage());
        this.fluent.withOsType(template.getOsType());
        this.fluent.withPrivateIpAddress(template.getPrivateIpAddress());
        this.fluent.withCommand(template.getCommand());
        this.fluent.withRootFs(template.getRootFs());
        this.fluent.withTimeout(template.getTimeout());
        this.fluent.withPorts(template.getPorts());
        this.fluent.withCpu(template.getCpu());
        this.fluent.withMemory(template.getMemory());
        RetentionStrategy<?> retentionStrategy = template.getRetentionStrategy();
        if (retentionStrategy instanceof ContainerIdleRetentionStrategy) {
            ContainerIdleRetentionStrategy strategy = (ContainerIdleRetentionStrategy)retentionStrategy;
            this.fluent.withIdleRetentionStrategy(strategy.getIdleMinutes());
        } else {
            this.fluent.withOnceRetentionStrategy();
        }
        this.fluent.withEnvVars(template.getEnvVars());
        this.fluent.withPrivateRegistryCredentials(template.getPrivateRegistryCredentials());
        this.fluent.withVolume(template.getVolumes());
        if (template.getLaunchMethodType().equals("jnlp")) {
            this.fluent.withJNLPLaunchMethod();
        } else {
            this.fluent.withSSHLaunchMethod(template.getSshCredentialsId(), template.getSshPort());
        }
    }

    public AciContainerTemplate build() {
        AciContainerTemplate template = new AciContainerTemplate(this.fluent.getName(), this.fluent.getLabel(), this.fluent.getTimeout(), this.fluent.getOsType(), this.fluent.getImage(), this.fluent.getCommand(), this.fluent.getRootFs(), this.fluent.getPorts(), this.fluent.getPrivateRegistryCredentials(), this.fluent.getEnvVars(), this.fluent.getVolumes(), this.fluent.getRetentionStrategy(), this.fluent.getCpu(), this.fluent.getMemory());
        template.setLaunchMethodType(this.fluent.getLaunchMethodType());
        template.setLaunchMethodTypeContent(new LaunchMethodTypeContent(this.fluent.getSshCredentialsId(), this.fluent.getSshPort()));
        template.setPrivateIpAddress(this.fluent.getPrivateIpAddress());
        return template;
    }
}

