// CHECKSTYLE:OFF

package com.microsoft.jenkins.artifactmanager;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code AzureArtifactManager_clear_stash}: {@code Delete {0}

     * stashes from {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Delete {0} stashes from {1}}
     */
    public static String AzureArtifactManager_clear_stash(Object arg0, Object arg1) {
        return holder.format("AzureArtifactManager_clear_stash", arg0, arg1);
    }

    /**
     * Key {@code AzureArtifactManager_clear_stash}: {@code Delete {0}

     * stashes from {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Delete {0} stashes from {1}}
     */
    public static Localizable _AzureArtifactManager_clear_stash(Object arg0, Object arg1) {
        return new Localizable(holder, "AzureArtifactManager_clear_stash", arg0, arg1);
    }

    /**
     * Key {@code AzureArtifactManager_clear_stash_fail}: {@code Fail to

     * clear stashes, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to clear stashes, details: {0}}
     */
    public static String AzureArtifactManager_clear_stash_fail(Object arg0) {
        return holder.format("AzureArtifactManager_clear_stash_fail", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_clear_stash_fail}: {@code Fail to

     * clear stashes, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to clear stashes, details: {0}}
     */
    public static Localizable _AzureArtifactManager_clear_stash_fail(Object arg0) {
        return new Localizable(holder, "AzureArtifactManager_clear_stash_fail", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_unstash_fail}: {@code Fail to unstash

     * artifacts, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to unstash artifacts, details: {0}}
     */
    public static String AzureArtifactManager_unstash_fail(Object arg0) {
        return holder.format("AzureArtifactManager_unstash_fail", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_unstash_fail}: {@code Fail to unstash

     * artifacts, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to unstash artifacts, details: {0}}
     */
    public static Localizable _AzureArtifactManager_unstash_fail(Object arg0) {
        return new Localizable(holder, "AzureArtifactManager_unstash_fail", arg0);
    }

    /**
     * Key {@code AzureArtifactConfig_invalid_container_name}: {@code "{0}"

     * is an invalid container name, please refer help for more information}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is an invalid container name, please refer help for more

     *     information}
     */
    public static String AzureArtifactConfig_invalid_container_name(Object arg0) {
        return holder.format("AzureArtifactConfig_invalid_container_name", arg0);
    }

    /**
     * Key {@code AzureArtifactConfig_invalid_container_name}: {@code "{0}"

     * is an invalid container name, please refer help for more information}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is an invalid container name, please refer help for more

     *     information}
     */
    public static Localizable _AzureArtifactConfig_invalid_container_name(Object arg0) {
        return new Localizable(holder, "AzureArtifactConfig_invalid_container_name", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_unstash_files}: {@code Unstash file(s)

     * from {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unstash file(s) from {0}}
     */
    public static String AzureArtifactManager_unstash_files(Object arg0) {
        return holder.format("AzureArtifactManager_unstash_files", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_unstash_files}: {@code Unstash file(s)

     * from {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unstash file(s) from {0}}
     */
    public static Localizable _AzureArtifactManager_unstash_files(Object arg0) {
        return new Localizable(holder, "AzureArtifactManager_unstash_files", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_archive}: {@code Archiving from {0}:

     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Archiving from {0}: {1}}
     */
    public static String AzureArtifactManager_archive(Object arg0, Object arg1) {
        return holder.format("AzureArtifactManager_archive", arg0, arg1);
    }

    /**
     * Key {@code AzureArtifactManager_archive}: {@code Archiving from {0}:

     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Archiving from {0}: {1}}
     */
    public static Localizable _AzureArtifactManager_archive(Object arg0, Object arg1) {
        return new Localizable(holder, "AzureArtifactManager_archive", arg0, arg1);
    }

    /**
     * Key {@code AzureArtifactManager_copy_all}: {@code Copy {0} artifacts

     * and {1} stashes from {2} to {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Copy {0} artifacts and {1} stashes from {2} to {3}}
     */
    public static String AzureArtifactManager_copy_all(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("AzureArtifactManager_copy_all", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code AzureArtifactManager_copy_all}: {@code Copy {0} artifacts

     * and {1} stashes from {2} to {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Copy {0} artifacts and {1} stashes from {2} to {3}}
     */
    public static Localizable _AzureArtifactManager_copy_all(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "AzureArtifactManager_copy_all", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code AzureArtifactManager_stash_fail}: {@code Fail to stash

     * artifacts, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to stash artifacts, details: {0}}
     */
    public static String AzureArtifactManager_stash_fail(Object arg0) {
        return holder.format("AzureArtifactManager_stash_fail", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_stash_fail}: {@code Fail to stash

     * artifacts, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to stash artifacts, details: {0}}
     */
    public static Localizable _AzureArtifactManager_stash_fail(Object arg0) {
        return new Localizable(holder, "AzureArtifactManager_stash_fail", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_stash_files}: {@code Stashed {0}

     * file(s) to {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stashed {0} file(s) to {1}}
     */
    public static String AzureArtifactManager_stash_files(Object arg0, Object arg1) {
        return holder.format("AzureArtifactManager_stash_files", arg0, arg1);
    }

    /**
     * Key {@code AzureArtifactManager_stash_files}: {@code Stashed {0}

     * file(s) to {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Stashed {0} file(s) to {1}}
     */
    public static Localizable _AzureArtifactManager_stash_files(Object arg0, Object arg1) {
        return new Localizable(holder, "AzureArtifactManager_stash_files", arg0, arg1);
    }

    /**
     * Key {@code AzureArtifactConfig_invalid_prefix}: {@code "{0}" is an

     * invalid prefix value. Only alphanumeric characters are allowed,and the

     * value must be 1-30 characters long. A forward slash is optional at the

     * end.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is an invalid prefix value. Only alphanumeric characters

     *     are allowed,and the value must be 1-30 characters long. A forward

     *     slash is optional at the end.}
     */
    public static String AzureArtifactConfig_invalid_prefix(Object arg0) {
        return holder.format("AzureArtifactConfig_invalid_prefix", arg0);
    }

    /**
     * Key {@code AzureArtifactConfig_invalid_prefix}: {@code "{0}" is an

     * invalid prefix value. Only alphanumeric characters are allowed,and the

     * value must be 1-30 characters long. A forward slash is optional at the

     * end.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is an invalid prefix value. Only alphanumeric characters

     *     are allowed,and the value must be 1-30 characters long. A forward

     *     slash is optional at the end.}
     */
    public static Localizable _AzureArtifactConfig_invalid_prefix(Object arg0) {
        return new Localizable(holder, "AzureArtifactConfig_invalid_prefix", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_archive_fail}: {@code Fail to archive

     * artifacts, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to archive artifacts, details: {0}}
     */
    public static String AzureArtifactManager_archive_fail(Object arg0) {
        return holder.format("AzureArtifactManager_archive_fail", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_archive_fail}: {@code Fail to archive

     * artifacts, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to archive artifacts, details: {0}}
     */
    public static Localizable _AzureArtifactManager_archive_fail(Object arg0) {
        return new Localizable(holder, "AzureArtifactManager_archive_fail", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_stash_no_file}: {@code No files

     * included in stash}.
     * 
     * @return
     *     {@code No files included in stash}
     */
    public static String AzureArtifactManager_stash_no_file() {
        return holder.format("AzureArtifactManager_stash_no_file");
    }

    /**
     * Key {@code AzureArtifactManager_stash_no_file}: {@code No files

     * included in stash}.
     * 
     * @return
     *     {@code No files included in stash}
     */
    public static Localizable _AzureArtifactManager_stash_no_file() {
        return new Localizable(holder, "AzureArtifactManager_stash_no_file");
    }

    /**
     * Key {@code AzureArtifactManager_cannot_copy}: {@code Cannot copy

     * artifacts and stashes to {0} using {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot copy artifacts and stashes to {0} using {1}}
     */
    public static String AzureArtifactManager_cannot_copy(Object arg0, Object arg1) {
        return holder.format("AzureArtifactManager_cannot_copy", arg0, arg1);
    }

    /**
     * Key {@code AzureArtifactManager_cannot_copy}: {@code Cannot copy

     * artifacts and stashes to {0} using {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cannot copy artifacts and stashes to {0} using {1}}
     */
    public static Localizable _AzureArtifactManager_cannot_copy(Object arg0, Object arg1) {
        return new Localizable(holder, "AzureArtifactManager_cannot_copy", arg0, arg1);
    }

    /**
     * Key {@code AzureArtifactManager_delete_fail}: {@code Fail to delete

     * artifacts, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to delete artifacts, details: {0}}
     */
    public static String AzureArtifactManager_delete_fail(Object arg0) {
        return holder.format("AzureArtifactManager_delete_fail", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_delete_fail}: {@code Fail to delete

     * artifacts, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to delete artifacts, details: {0}}
     */
    public static Localizable _AzureArtifactManager_delete_fail(Object arg0) {
        return new Localizable(holder, "AzureArtifactManager_delete_fail", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_unstash_not_found}: {@code No such

     * saved stash {0} found at {1}/{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such saved stash {0} found at {1}/{2}}
     */
    public static String AzureArtifactManager_unstash_not_found(Object arg0, Object arg1, Object arg2) {
        return holder.format("AzureArtifactManager_unstash_not_found", arg0, arg1, arg2);
    }

    /**
     * Key {@code AzureArtifactManager_unstash_not_found}: {@code No such

     * saved stash {0} found at {1}/{2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such saved stash {0} found at {1}/{2}}
     */
    public static Localizable _AzureArtifactManager_unstash_not_found(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "AzureArtifactManager_unstash_not_found", arg0, arg1, arg2);
    }

    /**
     * Key {@code AzureArtifactManager_stash_delete}: {@code Deleting stash

     * file {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deleting stash file {0}}
     */
    public static String AzureArtifactManager_stash_delete(Object arg0) {
        return holder.format("AzureArtifactManager_stash_delete", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_stash_delete}: {@code Deleting stash

     * file {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Deleting stash file {0}}
     */
    public static Localizable _AzureArtifactManager_stash_delete(Object arg0) {
        return new Localizable(holder, "AzureArtifactManager_stash_delete", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_copy_all_fail}: {@code Fail to copy

     * artifacts and stashes, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to copy artifacts and stashes, details: {0}}
     */
    public static String AzureArtifactManager_copy_all_fail(Object arg0) {
        return holder.format("AzureArtifactManager_copy_all_fail", arg0);
    }

    /**
     * Key {@code AzureArtifactManager_copy_all_fail}: {@code Fail to copy

     * artifacts and stashes, details: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fail to copy artifacts and stashes, details: {0}}
     */
    public static Localizable _AzureArtifactManager_copy_all_fail(Object arg0) {
        return new Localizable(holder, "AzureArtifactManager_copy_all_fail", arg0);
    }

}
