/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.artifactmanager;

import com.microsoft.jenkins.artifactmanager.AzureArtifactConfig;
import com.microsoft.jenkins.artifactmanager.AzureArtifactManager;
import com.microsoft.jenkins.artifactmanager.Utils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import jenkins.model.ArtifactManager;
import jenkins.model.ArtifactManagerFactory;
import jenkins.model.ArtifactManagerFactoryDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class AzureArtifactManagerFactory
extends ArtifactManagerFactory {
    private final AzureArtifactConfig config;

    @DataBoundConstructor
    public AzureArtifactManagerFactory(AzureArtifactConfig config) {
        if (config == null) {
            throw new IllegalArgumentException();
        }
        this.config = config;
    }

    public AzureArtifactConfig getConfig() {
        return this.config;
    }

    @CheckForNull
    public ArtifactManager managerFor(Run<?, ?> build) {
        return new AzureArtifactManager(build, Utils.getArtifactConfig());
    }

    @Extension
    public static final class DescriptorImpl
    extends ArtifactManagerFactoryDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Azure Artifact Storage";
        }
    }
}

