/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.artifactmanager;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.options.BlobUploadFromFileOptions;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.microsoft.jenkins.artifactmanager.AzureArtifactConfig;
import com.microsoft.jenkins.artifactmanager.AzureBlobVirtualFile;
import com.microsoft.jenkins.artifactmanager.Messages;
import com.microsoft.jenkins.artifactmanager.Utils;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import com.microsoftopentechnologies.windowsazurestorage.service.DownloadFromContainerService;
import com.microsoftopentechnologies.windowsazurestorage.service.UploadToBlobService;
import com.microsoftopentechnologies.windowsazurestorage.service.model.DownloadServiceData;
import com.microsoftopentechnologies.windowsazurestorage.service.model.UploadServiceData;
import com.microsoftopentechnologies.windowsazurestorage.service.model.UploadType;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import hudson.util.LogTaskListener;
import hudson.util.io.ArchiverFactory;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URLConnection;
import java.nio.file.Files;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.ArtifactManager;
import jenkins.model.Jenkins;
import jenkins.util.VirtualFile;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class AzureArtifactManager
extends ArtifactManager
implements StashManager.StashAwareArtifactManager {
    private static final Logger LOGGER = Logger.getLogger(ArtifactManager.class.getName());
    private transient Run<?, ?> build;
    private final AzureArtifactConfig config;
    private String actualContainerName;
    private transient String defaultKey;

    public AzureArtifactManager(Run<?, ?> build, AzureArtifactConfig config) {
        String containerName = config.getContainer();
        String prefix = config.getPrefix();
        this.checkConfig(containerName, prefix);
        this.config = config;
        this.onLoad(build);
    }

    private void checkConfig(String containerName, String prefix) {
        boolean isContainerNameValid;
        boolean bl = isContainerNameValid = Utils.containTokens(containerName) || Utils.validateContainerName(containerName);
        if (!isContainerNameValid) {
            throw new IllegalArgumentException(Messages.AzureArtifactConfig_invalid_container_name(containerName));
        }
        boolean isPrefixValid = Utils.isPrefixValid(prefix);
        if (!isPrefixValid) {
            throw new IllegalArgumentException(Messages.AzureArtifactConfig_invalid_prefix(prefix));
        }
    }

    public void onLoad(Run<?, ?> aBuild) {
        this.build = aBuild;
        this.defaultKey = String.format("%s/%s", aBuild.getParent().getFullName(), aBuild.getNumber()).replace("%2F", "/");
        if (this.actualContainerName == null) {
            try {
                EnvVars envVars = this.build.getEnvironment((TaskListener)new LogTaskListener(LOGGER, Level.INFO));
                this.actualContainerName = Utils.replaceMacro(Util.fixNull((String)this.config.getContainer()), (Map<String, String>)envVars, Locale.ENGLISH);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void archive(FilePath workspace, Launcher launcher, BuildListener listener, Map<String, String> artifacts) throws IOException, InterruptedException {
        if (artifacts.isEmpty()) {
            return;
        }
        LOGGER.fine(Messages.AzureArtifactManager_archive(workspace, artifacts));
        StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
        ArrayList<UploadObject> objects = new ArrayList<UploadObject>();
        Map contentTypes = (Map)workspace.act((FilePath.FileCallable)new ContentTypeGuesser(new ArrayList<String>(artifacts.keySet()), (TaskListener)listener));
        try {
            BlobContainerClient container = Utils.getBlobContainerReference(accountInfo, this.actualContainerName, true);
            for (Map.Entry entry : contentTypes.entrySet()) {
                String path = "artifacts/" + (String)entry.getKey();
                String blobPath = this.getBlobPath(path);
                BlobClient blobClient = container.getBlobClient(blobPath);
                String sas = this.generateSas(blobClient);
                String blobUrl = blobClient.getBlobUrl() + "?" + sas;
                UploadObject uploadObject = new UploadObject((String)entry.getKey(), blobUrl, (String)entry.getValue());
                objects.add(uploadObject);
            }
            workspace.act((FilePath.FileCallable)new UploadToBlobStorage(Jenkins.get().getProxy(), accountInfo.getBlobEndPointURL(), objects, (TaskListener)listener));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String generateSas(BlobClient blobClient) {
        BlobSasPermission permissions = new BlobSasPermission().setWritePermission(true);
        BlobServiceSasSignatureValues sasSignatureValues = new BlobServiceSasSignatureValues(Utils.generateExpiryDate(), permissions);
        return blobClient.generateSas(sasSignatureValues);
    }

    private String getBlobPath(String path) {
        return this.getBlobPath(this.defaultKey, path);
    }

    private String getBlobPath(String key, String path) {
        return String.format("%s%s/%s", this.config.getPrefix(), key, path);
    }

    private String getActualContainerName(TaskListener listener) throws IOException, InterruptedException {
        EnvVars envVars = this.build.getEnvironment(listener);
        this.actualContainerName = Utils.replaceMacro(Util.fixNull((String)this.config.getContainer()), (Map<String, String>)envVars, Locale.ENGLISH);
        return this.actualContainerName;
    }

    private String getVirtualPath(String path) {
        return this.getVirtualPath(this.defaultKey, path);
    }

    private String getVirtualPath(String key, String path) {
        return String.format("%s%s/%s", this.config.getPrefix(), key, path);
    }

    public boolean delete() throws IOException, InterruptedException {
        String virtualPath = this.getVirtualPath("");
        int count = this.deleteWithPrefix(virtualPath);
        return count > 0;
    }

    private int deleteWithPrefix(String prefix) throws IOException, InterruptedException {
        BlobContainerClient container = this.getContainer();
        ListBlobsOptions listBlobsOptions = new ListBlobsOptions().setPrefix(prefix);
        PagedIterable listBlobItems = container.listBlobs(listBlobsOptions, null);
        return this.deleteBlobs(container, (PagedIterable<BlobItem>)listBlobItems);
    }

    private int deleteBlobs(BlobContainerClient container, PagedIterable<BlobItem> blobItems) {
        int count = 0;
        for (BlobItem blobItem : blobItems) {
            BlobClient blobClient = container.getBlobClient(blobItem.getName());
            blobClient.delete();
        }
        return count;
    }

    private BlobContainerClient getContainer() throws IOException, InterruptedException {
        StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
        if (StringUtils.isEmpty((String)this.actualContainerName)) {
            this.actualContainerName = this.getActualContainerName((TaskListener)new LogTaskListener(LOGGER, Level.INFO));
        }
        return Utils.getBlobContainerReference(accountInfo, this.actualContainerName, false);
    }

    public VirtualFile root() {
        return new AzureBlobVirtualFile(this.actualContainerName, this.getVirtualPath("artifacts"), this.config.getDisableExternalUrl(), this.build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stash(@NonNull String name, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull EnvVars env, @NonNull TaskListener listener, @CheckForNull String includes, @CheckForNull String excludes, boolean useDefaultExcludes, boolean allowEmpty) throws IOException, InterruptedException {
        StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
        UploadServiceData serviceData = new UploadServiceData(this.build, workspace, launcher, listener, accountInfo);
        FilePath remoteWorkspace = serviceData.getRemoteWorkspace();
        FilePath stashTempFile = remoteWorkspace.child(name + ".tgz");
        try {
            int count = workspace.archive(ArchiverFactory.TARGZ, stashTempFile.write(), (DirScanner)new DirScanner.Glob(Util.fixEmpty((String)includes) == null ? "**" : includes, this.excludeFilesAndStash(excludes, stashTempFile.getName()), useDefaultExcludes));
            if (count == 0 && !allowEmpty) {
                throw new AbortException(Messages.AzureArtifactManager_stash_no_file());
            }
            listener.getLogger().println(Messages.AzureArtifactManager_stash_files(count, this.actualContainerName));
            serviceData.setVirtualPath(this.getVirtualPath("stashes/"));
            serviceData.setContainerName(this.getActualContainerName(listener));
            serviceData.setFilePath(stashTempFile.getName());
            serviceData.setUploadType(UploadType.INDIVIDUAL);
            UploadToBlobService uploadService = new UploadToBlobService(serviceData);
            try {
                uploadService.execute();
            }
            catch (WAStorageException e) {
                listener.getLogger().println(Messages.AzureArtifactManager_stash_fail((Object)e));
                throw new IOException(e);
            }
        }
        finally {
            stashTempFile.delete();
            listener.getLogger().println(Messages.AzureArtifactManager_stash_delete(stashTempFile.getName()));
        }
    }

    private String excludeFilesAndStash(String excludes, String stashFile) {
        List<String> strings = Arrays.asList(excludes, stashFile);
        return String.join((CharSequence)",", strings);
    }

    public void unstash(@NonNull String name, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull EnvVars env, @NonNull TaskListener listener) throws IOException, InterruptedException {
        StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
        DownloadServiceData serviceData = new DownloadServiceData(this.build, workspace, launcher, listener, accountInfo);
        serviceData.setContainerName(this.getActualContainerName(listener));
        String stashes = this.getVirtualPath("stashes/");
        serviceData.setIncludeFilesPattern(stashes + name + ".tgz");
        serviceData.setFlattenDirectories(true);
        workspace.mkdirs();
        DownloadFromContainerService downloadService = new DownloadFromContainerService(serviceData);
        try {
            downloadService.execute();
        }
        catch (WAStorageException e) {
            listener.getLogger().println(Messages.AzureArtifactManager_unstash_fail((Object)e));
            throw new IOException(e);
        }
        FilePath[] stashList = workspace.list(name + ".tgz");
        if (stashList.length == 0) {
            throw new AbortException(Messages.AzureArtifactManager_unstash_not_found(name, this.actualContainerName, this.getVirtualPath("stashes/")));
        }
        FilePath stashFile = stashList[0];
        workspace.untarFrom(stashFile.read(), FilePath.TarCompression.GZIP);
        stashFile.delete();
        listener.getLogger().println(Messages.AzureArtifactManager_unstash_files(stashFile.getName()));
    }

    public void clearAllStashes(@NonNull TaskListener listener) throws IOException, InterruptedException {
        String virtualPath = this.getVirtualPath("stashes/");
        int count = this.deleteWithPrefix(virtualPath);
        listener.getLogger().println(Messages.AzureArtifactManager_clear_stash(count, this.actualContainerName));
    }

    public void copyAllArtifactsAndStashes(@NonNull Run<?, ?> to, @NonNull TaskListener listener) throws IOException {
        ArtifactManager artifactManager = to.pickArtifactManager();
        if (!(artifactManager instanceof AzureArtifactManager)) {
            throw new AbortException(Messages.AzureArtifactManager_cannot_copy(to, artifactManager.getClass().getName()));
        }
        AzureArtifactManager azureArtifactManager = (AzureArtifactManager)artifactManager;
        try {
            int artifactsCount = this.copyBlobsWithPrefix("artifacts/", azureArtifactManager.defaultKey);
            int stashesCount = this.copyBlobsWithPrefix("stashes/", azureArtifactManager.defaultKey);
            listener.getLogger().println(Messages.AzureArtifactManager_copy_all(artifactsCount, stashesCount, this.defaultKey, azureArtifactManager.defaultKey));
        }
        catch (InterruptedException e) {
            listener.getLogger().println(Messages.AzureArtifactManager_copy_all_fail(e));
            throw new IOException(e);
        }
    }

    private int copyBlobs(PagedIterable<BlobItem> sourceBlobs, String toKey, BlobContainerClient container) {
        int count = 0;
        for (BlobItem sourceBlob : sourceBlobs) {
            if (Boolean.TRUE.equals(sourceBlob.isPrefix())) {
                count += this.copyBlobs((PagedIterable<BlobItem>)container.listBlobsByHierarchy(sourceBlob.getName()), toKey, container);
                continue;
            }
            String destFilePath = sourceBlob.getName().replace(this.defaultKey, toKey);
            BlobClient blobClient = container.getBlobClient(sourceBlob.getName());
            BlobClient destBlob = container.getBlobClient(destFilePath);
            String srcBlobUrl = blobClient.getBlobUrl();
            String srcBlobSas = blobClient.generateSas(Utils.generateBlobPolicy());
            destBlob.copyFromUrl(srcBlobUrl + "?" + srcBlobSas);
            ++count;
        }
        return count;
    }

    private int copyBlobsWithPrefix(String prefix, String toKey) throws IOException, InterruptedException {
        BlobContainerClient container = this.getContainer();
        String sourcePath = this.getVirtualPath(prefix);
        PagedIterable sourceBlobs = container.listBlobsByHierarchy(sourcePath);
        return this.copyBlobs((PagedIterable<BlobItem>)sourceBlobs, toKey, container);
    }

    private static class ContentTypeGuesser
    extends MasterToSlaveFileCallable<Map<String, String>> {
        private static final long serialVersionUID = 1L;
        private final Collection<String> relPaths;
        private final TaskListener listener;

        ContentTypeGuesser(Collection<String> relPaths, TaskListener listener) {
            this.relPaths = relPaths;
            this.listener = listener;
        }

        public Map<String, String> invoke(File f, VirtualChannel channel) {
            HashMap<String, String> contentTypes = new HashMap<String, String>();
            for (String relPath : this.relPaths) {
                File theFile = new File(f, relPath);
                try {
                    String contentType = Files.probeContentType(theFile.toPath());
                    if (contentType == null) {
                        contentType = URLConnection.guessContentTypeFromName(theFile.getName());
                    }
                    contentTypes.put(relPath, contentType);
                }
                catch (IOException e) {
                    Functions.printStackTrace((Throwable)e, (PrintWriter)this.listener.error("Unable to determine content type for file: " + String.valueOf(theFile)));
                }
            }
            return contentTypes;
        }
    }

    private static class UploadObject
    implements Serializable {
        private final String name;
        private final String url;
        private final String contentType;

        UploadObject(String name, String url, String contentType) {
            this.name = name;
            this.url = url;
            this.contentType = contentType;
        }

        public String getName() {
            return this.name;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getUrl() {
            return this.url;
        }
    }

    private static class UploadToBlobStorage
    extends MasterToSlaveFileCallable<Void> {
        public static final int MAX_QUEUE_SIZE_IN_NETTY = 500;
        public static final int TIMEOUT = 600;
        private final ProxyConfiguration proxy;
        private final String blobEndpoint;
        private final List<UploadObject> uploadObjects;
        private final TaskListener listener;

        UploadToBlobStorage(ProxyConfiguration proxy, String blobEndpoint, List<UploadObject> uploadObjects, TaskListener listener) {
            this.proxy = proxy;
            this.blobEndpoint = blobEndpoint;
            this.uploadObjects = uploadObjects;
            this.listener = listener;
        }

        private BlobServiceAsyncClient getBlobServiceClient(String sas) {
            return new BlobServiceClientBuilder().credential(new AzureSasCredential(sas)).httpClient(HttpClientRetriever.get((ProxyConfiguration)this.proxy)).endpoint(this.blobEndpoint).buildAsyncClient();
        }

        private BlobServiceClient getSynchronousBlobServiceClient(String sas) {
            return new BlobServiceClientBuilder().credential(new AzureSasCredential(sas)).httpClient(HttpClientRetriever.get((ProxyConfiguration)this.proxy)).endpoint(this.blobEndpoint).buildClient();
        }

        public Void invoke(File f, VirtualChannel channel) {
            if (this.uploadObjects.size() < 500) {
                CountDownLatch latch = new CountDownLatch(this.uploadObjects.size());
                for (UploadObject uploadObject2 : this.uploadObjects) {
                    BlobUrlParts blobUrlParts = BlobUrlParts.parse((String)uploadObject2.getUrl());
                    BlobAsyncClient blobClient = this.getBlobClient(blobUrlParts);
                    String file = new File(f, uploadObject2.getName()).getAbsolutePath();
                    BlobUploadFromFileOptions options = new BlobUploadFromFileOptions(file).setHeaders(this.getBlobHttpHeaders(uploadObject2));
                    blobClient.uploadFromFileWithResponse(options).doOnError(throwable -> this.listener.error("[AzureStorage] Failed to upload file %s, error: %s", new Object[]{file, throwable.getMessage()})).doOnSuccess(response -> latch.countDown()).subscribe();
                }
                try {
                    if (!latch.await(Math.max(600, 600 * this.uploadObjects.size()), TimeUnit.SECONDS)) {
                        this.listener.error("[AzureStorage] Timeout occurred while uploading files");
                    }
                }
                catch (InterruptedException e) {
                    this.listener.error("[AzureStorage] Upload process was interrupted", new Object[]{e});
                    Thread.currentThread().interrupt();
                }
            } else {
                try {
                    this.uploadObjects.parallelStream().forEach(uploadObject -> {
                        BlobUrlParts blobUrlParts = BlobUrlParts.parse((String)uploadObject.getUrl());
                        BlobClient blobClient = this.getSynchronousBlobClient(blobUrlParts);
                        String file = new File(f, uploadObject.getName()).getAbsolutePath();
                        BlobUploadFromFileOptions options = new BlobUploadFromFileOptions(file).setHeaders(this.getBlobHttpHeaders((UploadObject)uploadObject));
                        try {
                            blobClient.uploadFromFileWithResponse(options, Duration.ofSeconds(600L), null);
                        }
                        catch (Exception e) {
                            this.listener.error("[AzureStorage] Failed to upload file %s, error: %s", new Object[]{file, e.getMessage()});
                            throw new CompletionException(e);
                        }
                    });
                }
                catch (CompletionException e) {
                    this.listener.error("[AzureStorage] One or more file uploads failed");
                }
            }
            return null;
        }

        private BlobAsyncClient getBlobClient(BlobUrlParts blobUrlParts) {
            String sas = blobUrlParts.getCommonSasQueryParameters().encode();
            BlobServiceAsyncClient blobServiceClient = this.getBlobServiceClient(sas);
            BlobContainerAsyncClient containerClient = blobServiceClient.getBlobContainerAsyncClient(blobUrlParts.getBlobContainerName());
            return containerClient.getBlobAsyncClient(blobUrlParts.getBlobName());
        }

        private BlobClient getSynchronousBlobClient(BlobUrlParts blobUrlParts) {
            String sas = blobUrlParts.getCommonSasQueryParameters().encode();
            BlobServiceClient blobServiceClient = this.getSynchronousBlobServiceClient(sas);
            BlobContainerClient containerClient = blobServiceClient.getBlobContainerClient(blobUrlParts.getBlobContainerName());
            return containerClient.getBlobClient(blobUrlParts.getBlobName());
        }

        private BlobHttpHeaders getBlobHttpHeaders(UploadObject uploadObject) {
            BlobHttpHeaders method = new BlobHttpHeaders();
            method.setContentType(uploadObject.getContentType());
            return method;
        }
    }
}

