/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.artifactmanager;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobItemProperties;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.microsoft.jenkins.artifactmanager.AzureAbstractVirtualFile;
import com.microsoft.jenkins.artifactmanager.Utils;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.Run;
import hudson.remoting.Callable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.OffsetDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.VirtualFile;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class AzureBlobVirtualFile
extends AzureAbstractVirtualFile {
    private static final long serialVersionUID = 9054620703341308471L;
    private static final Logger LOGGER = Logger.getLogger(AzureBlobVirtualFile.class.getName());
    private static final int NOT_FOUND = 404;
    private final String container;
    private final String key;
    private Boolean disableExternalUrl;
    private final transient Run<?, ?> build;
    private static final ThreadLocal<Map<String, Deque<CacheFrame>>> CACHE = ThreadLocal.withInitial(HashMap::new);

    public AzureBlobVirtualFile(String container, String key, boolean disableExternalUrl, Run<?, ?> build) {
        this.container = container;
        this.key = key;
        this.build = build;
        this.disableExternalUrl = disableExternalUrl;
    }

    public String getContainer() {
        return this.container;
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V run(Callable<V, IOException> callable) throws IOException {
        Object object;
        LOGGER.log(Level.FINE, "enter cache {0} / {1}", new Object[]{this.container, this.key});
        Deque<CacheFrame> stack = this.cacheFrames();
        HashMap<String, CachedMetadata> saved = new HashMap<String, CachedMetadata>();
        try {
            StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
            BlobContainerClient blobContainerReference = Utils.getBlobContainerReference(accountInfo, this.container, false);
            ListBlobsOptions listBlobsOptions = new ListBlobsOptions().setPrefix(this.key);
            for (BlobItem sm : blobContainerReference.listBlobs(listBlobsOptions, null)) {
                BlobItemProperties properties = sm.getProperties();
                OffsetDateTime lastModified = properties.getLastModified();
                long lastModifiedMilli = lastModified.toInstant().toEpochMilli();
                String fileName = this.stripBeginningSlash(sm.getName().replaceFirst(this.key, ""));
                saved.put(fileName, new CachedMetadata(properties.getContentLength(), lastModifiedMilli));
            }
        }
        catch (RuntimeException x) {
            throw new IOException(x);
        }
        stack.push(new CacheFrame(this.stripTrailingSlash(this.key) + "/", saved));
        try {
            LOGGER.log(Level.FINE, "using cache {0} / {1}: {2} file entries", new Object[]{this.container, this.key, saved.size()});
            object = callable.call();
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.FINE, "exit cache {0} / {1}", new Object[]{this.container, this.key});
            stack.pop();
            throw throwable;
        }
        LOGGER.log(Level.FINE, "exit cache {0} / {1}", new Object[]{this.container, this.key});
        stack.pop();
        return (V)object;
    }

    private Deque<CacheFrame> cacheFrames() {
        return CACHE.get().computeIfAbsent(this.container, c -> new ArrayDeque());
    }

    @CheckForNull
    private CacheFrame findCacheFrame(String cacheKey) {
        return this.cacheFrames().stream().filter(frame -> cacheKey.startsWith(frame.root)).findFirst().orElse(null);
    }

    @NonNull
    public String getName() {
        String localKey = this.stripTrailingSlash(this.key);
        return localKey.replaceFirst(".+/", "");
    }

    private String stripTrailingSlash(String string) {
        String localKey = string;
        if (string.endsWith("/")) {
            localKey = localKey.substring(0, localKey.length() - 1);
        }
        return localKey;
    }

    private String stripBeginningSlash(String string) {
        String localKey = string;
        if (string.startsWith("/")) {
            localKey = localKey.substring(1);
        }
        return localKey;
    }

    @NonNull
    public URI toURI() {
        StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
        try {
            return new URI(Utils.getBlobUrl(accountInfo, this.container, this.key));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @CheckForNull
    public URL toExternalURL() throws IOException {
        if (!this.disableExternalUrl.booleanValue()) {
            String sas;
            StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
            try {
                sas = Utils.generateBlobSASURL(accountInfo, this.container, this.key);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return new URL(String.valueOf(this.toURI()) + "?" + sas);
        }
        return null;
    }

    public VirtualFile getParent() {
        return new AzureBlobVirtualFile(this.container, this.key.replaceFirst("/[^/]+$", ""), this.disableExternalUrl, this.build);
    }

    public boolean isDirectory() {
        String keyWithNoSlash = this.stripTrailingSlash(this.key);
        if (keyWithNoSlash.endsWith("/*view*")) {
            return false;
        }
        String keyS = keyWithNoSlash + "/";
        CacheFrame frame = this.findCacheFrame(keyS);
        if (frame != null) {
            LOGGER.log(Level.FINER, "cache hit on directory status of {0} / {1}", new Object[]{this.container, this.key});
            String relSlash = this.stripTrailingSlash(keyS.substring(frame.root.length()));
            Set<String> children = frame.children.keySet();
            boolean existsInCache = children.stream().anyMatch(f -> f.startsWith(relSlash));
            if (!existsInCache) {
                return false;
            }
            return children.stream().noneMatch(f -> f.equals(relSlash));
        }
        LOGGER.log(Level.FINE, "checking directory status {0} / {1}", new Object[]{this.container, keyWithNoSlash});
        StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
        BlobContainerClient blobContainerReference = Utils.getBlobContainerReference(accountInfo, this.container, false);
        Iterator iterator = blobContainerReference.listBlobsByHierarchy(keyS).iterator();
        return iterator.hasNext();
    }

    public boolean isFile() {
        String keyS = this.key + "/";
        if (keyS.endsWith("/*view*/")) {
            return false;
        }
        CacheFrame frame = this.findCacheFrame(keyS);
        if (frame != null) {
            String rel = this.stripTrailingSlash(keyS.substring(frame.root.length()));
            CachedMetadata metadata = frame.children.get(rel);
            LOGGER.log(Level.FINER, "cache hit on file status of {0} / {1}", new Object[]{this.container, this.key});
            return metadata != null;
        }
        StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
        BlobContainerClient blobContainerReference = Utils.getBlobContainerReference(accountInfo, this.container, false);
        BlobClient blockBlobReference = blobContainerReference.getBlobClient(this.key);
        return blockBlobReference.exists();
    }

    public boolean exists() {
        return this.isDirectory() || this.isFile();
    }

    @NonNull
    public VirtualFile[] list() {
        String keyS = this.key + "/";
        CacheFrame frame = this.findCacheFrame(keyS);
        if (frame != null) {
            LOGGER.log(Level.FINER, "cache hit on listing of {0} / {1}", new Object[]{this.container, this.key});
            String relSlash = keyS.substring(frame.root.length());
            VirtualFile[] virtualFiles = (VirtualFile[])frame.children.keySet().stream().filter(f -> f.startsWith(relSlash)).map(f -> f.substring(relSlash.length()).replaceFirst("/.+", "")).distinct().map(simple -> new AzureBlobVirtualFile(this.container, keyS + simple, this.disableExternalUrl, this.build)).toArray(VirtualFile[]::new);
            return virtualFiles;
        }
        String keys = this.stripTrailingSlash(this.key) + "/";
        StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
        BlobContainerClient blobContainerReference = Utils.getBlobContainerReference(accountInfo, this.container, false);
        VirtualFile[] list = this.listBlobsFromPrefix(keys, blobContainerReference).toArray(new VirtualFile[0]);
        return list;
    }

    private List<VirtualFile> listBlobsFromPrefix(String keys, BlobContainerClient blobContainerReference) {
        PagedIterable blobItems = blobContainerReference.listBlobsByHierarchy(keys);
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (BlobItem blobItem : blobItems) {
            files.add(new AzureBlobVirtualFile(this.container, this.stripTrailingSlash(blobItem.getName()), this.disableExternalUrl, this.build));
        }
        return files;
    }

    @NonNull
    public VirtualFile child(@NonNull String name) {
        String joinedKey = this.stripTrailingSlash(this.key) + "/" + name;
        return new AzureBlobVirtualFile(this.container, joinedKey, this.disableExternalUrl, this.build);
    }

    public long length() throws IOException {
        String keyS = this.key + "/";
        CacheFrame frame = this.findCacheFrame(keyS);
        if (frame != null) {
            String rel = this.stripTrailingSlash(keyS.substring(frame.root.length()));
            CachedMetadata metadata = frame.children.get(rel);
            LOGGER.log(Level.FINER, "cache hit on length of {0} / {1}", new Object[]{this.container, this.key});
            return metadata != null ? metadata.length : 0L;
        }
        StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
        try {
            BlobContainerClient blobContainerReference = Utils.getBlobContainerReference(accountInfo, this.container, false);
            BlobClient blobClient = blobContainerReference.getBlobClient(this.key);
            BlobProperties properties = blobClient.getProperties();
            return properties.getBlobSize();
        }
        catch (BlobStorageException e) {
            if (e.getStatusCode() == 404) {
                return 0L;
            }
            throw new IOException(e.getMessage());
        }
    }

    public long lastModified() throws IOException {
        String keyS = this.key + "/";
        CacheFrame frame = this.findCacheFrame(keyS);
        if (frame != null) {
            String rel = this.stripTrailingSlash(keyS.substring(frame.root.length()));
            CachedMetadata metadata = frame.children.get(rel);
            LOGGER.log(Level.FINER, "cache hit on lastModified of {0} / {1}", new Object[]{this.container, this.key});
            return metadata != null ? metadata.lastModified : 0L;
        }
        if (this.isDirectory()) {
            return 0L;
        }
        StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
        try {
            BlobContainerClient blobContainerReference = Utils.getBlobContainerReference(accountInfo, this.container, false);
            BlobClient blockBlobReference = blobContainerReference.getBlobClient(this.key);
            BlobProperties properties = blockBlobReference.getProperties();
            OffsetDateTime lastModified = properties.getLastModified();
            return lastModified == null ? 0L : lastModified.toInstant().toEpochMilli();
        }
        catch (BlobStorageException e) {
            if (e.getStatusCode() == 404) {
                return 0L;
            }
            throw new IOException(e.getMessage());
        }
    }

    public boolean canRead() {
        return true;
    }

    public InputStream open() throws IOException {
        if (this.isDirectory()) {
            throw new FileNotFoundException("Cannot open it because it is a directory.");
        }
        if (!this.isFile()) {
            throw new FileNotFoundException("Cannot open it because it is not a file.");
        }
        StorageAccountInfo accountInfo = Utils.getStorageAccount((Item)this.build.getParent());
        BlobContainerClient blobContainerReference = Utils.getBlobContainerReference(accountInfo, this.container, false);
        BlobClient blockBlobReference = blobContainerReference.getBlobClient(this.key);
        return blockBlobReference.openInputStream();
    }

    private static final class CachedMetadata {
        private final long length;
        private final long lastModified;

        CachedMetadata(long length, long lastModified) {
            this.length = length;
            this.lastModified = lastModified;
        }
    }

    private static final class CacheFrame {
        private final String root;
        private final Map<String, CachedMetadata> children;

        CacheFrame(String root, Map<String, CachedMetadata> children) {
            this.root = root;
            this.children = children;
        }
    }
}

