/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.artifactmanager;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.microsoft.jenkins.artifactmanager.Messages;
import com.microsoft.jenkins.artifactmanager.Utils;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureStorageAccount;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.Collections;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class AzureArtifactConfig
extends AbstractDescribableImpl<AzureArtifactConfig>
implements Serializable {
    private static final long serialVersionUID = -3283542207832596121L;
    private String storageCredentialId;
    private String container;
    private String prefix;
    private boolean disableExternalUrl;

    public AzureArtifactConfig() {
    }

    @DataBoundConstructor
    public AzureArtifactConfig(String storageCredentialId) {
        this.storageCredentialId = storageCredentialId;
    }

    public String getContainer() {
        return this.container;
    }

    @DataBoundSetter
    public void setContainer(String container) {
        this.container = container;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @DataBoundSetter
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean getDisableExternalUrl() {
        return this.disableExternalUrl;
    }

    @DataBoundSetter
    public void setDisableExternalUrl(boolean disableExternalUrl) {
        this.disableExternalUrl = disableExternalUrl;
    }

    public String getStorageCredentialId() {
        return this.storageCredentialId;
    }

    public static AzureArtifactConfig get() {
        return (AzureArtifactConfig)ExtensionList.lookupSingleton(AzureArtifactConfig.class);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AzureArtifactConfig> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }

        @NonNull
        public String getDisplayName() {
            return "Azure Blob Storage";
        }

        public ListBoxModel doFillStorageCredentialIdItems(@AncestorInPath Item item) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(AzureArtifactConfig.get().getStorageCredentialId());
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, item, AzureStorageAccount.class, Collections.emptyList(), CredentialsMatchers.instanceOf(AzureStorageAccount.class)).includeCurrentValue(AzureArtifactConfig.get().getStorageCredentialId());
        }

        public FormValidation doCheckContainer(@QueryParameter String container) {
            boolean isValid;
            boolean bl = isValid = Utils.containTokens(container) || Utils.validateContainerName(container);
            if (!isValid) {
                return FormValidation.error((String)Messages.AzureArtifactConfig_invalid_container_name(container));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPrefix(@QueryParameter String prefix) {
            boolean isValid = Utils.isPrefixValid(prefix);
            if (!isValid) {
                return FormValidation.error((String)Messages.AzureArtifactConfig_invalid_prefix(prefix));
            }
            return FormValidation.ok();
        }
    }
}

