/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.artifactmanager;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.microsoft.jenkins.artifactmanager.AzureArtifactConfig;
import com.microsoft.jenkins.artifactmanager.AzureArtifactManagerFactory;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureStorageAccount;
import hudson.Util;
import hudson.model.Item;
import hudson.util.DescribableList;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.time.OffsetDateTime;
import java.util.Locale;
import java.util.Map;
import jenkins.model.ArtifactManagerConfiguration;
import org.apache.commons.lang.StringUtils;

public final class Utils {
    private static final String PREFIX_PATTERN = "^[a-z0-9A-Z]{1,30}/?$";
    private static final int CONFLICT = 409;

    public static AzureArtifactConfig getArtifactConfig() {
        ArtifactManagerConfiguration artifactManagerConfiguration = ArtifactManagerConfiguration.get();
        DescribableList artifactManagerFactories = artifactManagerConfiguration.getArtifactManagerFactories();
        AzureArtifactManagerFactory azureArtifactManagerFactory = (AzureArtifactManagerFactory)artifactManagerFactories.get(AzureArtifactManagerFactory.class);
        return azureArtifactManagerFactory.getConfig();
    }

    public static boolean validateContainerName(String containerName) {
        if (containerName != null) {
            if (containerName.equals("$root") || containerName.equals("$web")) {
                return true;
            }
            String lcContainerName = containerName.trim().toLowerCase(Locale.ENGLISH);
            if (!lcContainerName.equals(containerName)) {
                return false;
            }
            return lcContainerName.matches("^(([a-z\\d]((-(?=[a-z\\d]))|([a-z\\d])){2,62}))$");
        }
        return false;
    }

    public static boolean isPrefixValid(String prefix) {
        if (StringUtils.isEmpty((String)prefix)) {
            return true;
        }
        return prefix.matches(PREFIX_PATTERN);
    }

    public static boolean containTokens(String text) {
        if (StringUtils.isBlank((String)text)) {
            return false;
        }
        return text.matches("\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\})");
    }

    public static String replaceMacro(String s, Map<String, String> props, Locale locale) {
        String result = Util.replaceMacro((String)s, props);
        if (result == null) {
            return null;
        }
        return result.trim().toLowerCase(locale);
    }

    public static StorageAccountInfo getStorageAccount(Item item) {
        AzureArtifactConfig config = Utils.getArtifactConfig();
        AzureStorageAccount.StorageAccountCredential accountCredentials = AzureStorageAccount.getStorageAccountCredential((Item)item, (String)config.getStorageCredentialId());
        return AzureStorageAccount.convertToStorageAccountInfo((AzureStorageAccount.StorageAccountCredential)accountCredentials);
    }

    public static String getBlobUrl(StorageAccountInfo storageAccount, String containerName, String blobName) {
        BlobServiceClient cloudStorageAccount = Utils.getCloudStorageAccount(storageAccount);
        BlobContainerClient container = cloudStorageAccount.getBlobContainerClient(containerName);
        BlobClient blob = container.getBlobClient(blobName);
        String cdnEndpoint = storageAccount.getCdnEndPointURL();
        if (!StringUtils.isBlank((String)cdnEndpoint)) {
            return cdnEndpoint + "/" + blob.getContainerName() + "/" + blob.getBlobName();
        }
        return blob.getBlobUrl();
    }

    public static String generateBlobSASURL(StorageAccountInfo storageAccount, String containerName, String blobName) {
        BlobServiceClient cloudStorageAccount = Utils.getCloudStorageAccount(storageAccount);
        BlobContainerClient container = cloudStorageAccount.getBlobContainerClient(containerName);
        BlobClient blob = container.getBlobClient(blobName);
        return blob.generateSas(Utils.generateBlobPolicy());
    }

    public static BlobServiceSasSignatureValues generateBlobPolicy() {
        return new BlobServiceSasSignatureValues(Utils.generateExpiryDate(), new BlobSasPermission().setReadPermission(true));
    }

    public static OffsetDateTime generateExpiryDate() {
        return OffsetDateTime.now().plusHours(1L);
    }

    public static BlobContainerClient getBlobContainerReference(StorageAccountInfo storageAccount, String containerName, boolean createIfNotExist) {
        BlobContainerClient container;
        block3: {
            BlobServiceClient serviceClient = Utils.getCloudStorageAccount(storageAccount);
            container = serviceClient.getBlobContainerClient(containerName);
            if (createIfNotExist && !container.exists()) {
                try {
                    container.create();
                }
                catch (BlobStorageException e) {
                    if (e.getStatusCode() == 409) break block3;
                    throw e;
                }
            }
        }
        return container;
    }

    public static BlobServiceClient getCloudStorageAccount(StorageAccountInfo storageAccount) {
        return new BlobServiceClientBuilder().credential(new StorageSharedKeyCredential(storageAccount.getStorageAccName(), storageAccount.getStorageAccountKey())).httpClient(HttpClientRetriever.get()).endpoint(storageAccount.getBlobEndPointURL()).buildClient();
    }

    private Utils() {
    }
}

