/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See LICENSE file in the project root for license information.
 */

package com.microsoft.jenkins.azuread;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.SecurityRealm;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public class AzureAuthFailAction implements UnprotectedRootAction {

    /** The URL of the action. */
    static final String POST_LOGOUT_URL = "/azureAuthFail";

    @Override
    public String getDisplayName() {
        return "Azure Auth Fail";
    }

    @Override
    public String getIconFileName() {
        // hide it
        return null;
    }

    @Override
    public String getUrlName() {
        return POST_LOGOUT_URL;
    }

    @Restricted(NoExternalUse.class) // jelly only
    public String getAzureURL() {
        Jenkins j = Jenkins.get();
        SecurityRealm r = j.getSecurityRealm();
        if (r instanceof AzureSecurityRealm) {
            return Constants.AZURE_PORTAL_URL;
        }
        return "";
    }

    @Restricted(NoExternalUse.class) // jelly only
    public String getAzureText() {
        Jenkins j = Jenkins.get();
        SecurityRealm r = j.getSecurityRealm();
        if (r instanceof AzureSecurityRealm) {
            return "Azure";
        }
        return "";
    }
}
