/*
 * The MIT License
 *
 * Copyright (c) 2021 CloudBees, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.microsoft.jenkins.azuread;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

/**
 * @since 3.0
 */
@Restricted(NoExternalUse.class)
public final class DeprecationUtil {
    private DeprecationUtil() {
        // do not instantiate
    }
    /**
     * Logs a message using the caller's logger about the caller's caller.
     */
    public static void logDeprecationMessage() {
        final StackTraceElement[] stackTrace = new Exception().getStackTrace();

        if (stackTrace.length < 3) {
            return;
        }

        final StackTraceElement calledDeprecatedMethod = stackTrace[1];
        final StackTraceElement caller = stackTrace[2];

        Logger.getLogger(calledDeprecatedMethod.getClassName())
                .log(
                        Level.INFO,
                        () -> "Deprecated method " + calledDeprecatedMethod.getClassName() + "#"
                                + calledDeprecatedMethod.getMethodName() + " called by " + caller.getClassName());
    }
}