/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.awscredentials;

import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsImpl;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AmazonWebServicesCredentialsBinding
extends MultiBinding<AmazonWebServicesCredentials> {
    public static final String DEFAULT_ACCESS_KEY_ID_VARIABLE_NAME = "AWS_ACCESS_KEY_ID";
    private static final String DEFAULT_SECRET_ACCESS_KEY_VARIABLE_NAME = "AWS_SECRET_ACCESS_KEY";
    private static final String SESSION_TOKEN_VARIABLE_NAME = "AWS_SESSION_TOKEN";
    @NonNull
    private final String accessKeyVariable;
    @NonNull
    private final String secretKeyVariable;
    private String roleArn;
    private String roleSessionName;
    private int roleSessionDurationSeconds;

    @DataBoundConstructor
    public AmazonWebServicesCredentialsBinding(@Nullable String accessKeyVariable, @Nullable String secretKeyVariable, String credentialsId) {
        super(credentialsId);
        this.accessKeyVariable = StringUtils.defaultIfBlank((String)accessKeyVariable, (String)DEFAULT_ACCESS_KEY_ID_VARIABLE_NAME);
        this.secretKeyVariable = StringUtils.defaultIfBlank((String)secretKeyVariable, (String)DEFAULT_SECRET_ACCESS_KEY_VARIABLE_NAME);
    }

    @NonNull
    public String getAccessKeyVariable() {
        return this.accessKeyVariable;
    }

    @NonNull
    public String getSecretKeyVariable() {
        return this.secretKeyVariable;
    }

    @Nullable
    public String getRoleArn() {
        return this.roleArn;
    }

    @Nullable
    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    public int getRoleSessionDurationSeconds() {
        return this.roleSessionDurationSeconds;
    }

    @DataBoundSetter
    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    @DataBoundSetter
    public void setRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
    }

    @DataBoundSetter
    public void setRoleSessionDurationSeconds(int roleSessionDurationSeconds) {
        this.roleSessionDurationSeconds = roleSessionDurationSeconds;
    }

    protected Class<AmazonWebServicesCredentials> type() {
        return AmazonWebServicesCredentials.class;
    }

    public MultiBinding.MultiEnvironment bind(@NonNull Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        AwsCredentialsProvider provider = (AwsCredentialsProvider)this.getCredentials(build);
        if (!StringUtils.isEmpty((String)this.roleArn)) {
            provider = this.assumeRoleProvider(provider);
        }
        AwsCredentials credentials = provider.resolveCredentials();
        HashMap<String, String> m = new HashMap<String, String>();
        if (credentials != null) {
            m.put(this.accessKeyVariable, credentials.accessKeyId());
            m.put(this.secretKeyVariable, credentials.secretAccessKey());
        }
        if (credentials instanceof AwsSessionCredentials) {
            m.put(SESSION_TOKEN_VARIABLE_NAME, ((AwsSessionCredentials)credentials).sessionToken());
        }
        return new MultiBinding.MultiEnvironment(m);
    }

    private AwsCredentialsProvider assumeRoleProvider(AwsCredentialsProvider baseProvider) {
        StsClient stsClient = AWSCredentialsImpl.buildStsClient(baseProvider);
        String roleSessionName = StringUtils.defaultIfBlank((String)this.roleSessionName, (String)"Jenkins");
        AssumeRoleRequest.Builder assumeRoleRequest = AssumeRoleRequest.builder().roleArn(this.roleArn).roleSessionName(roleSessionName);
        if (this.roleSessionDurationSeconds > 0) {
            assumeRoleRequest.durationSeconds(Integer.valueOf(this.roleSessionDurationSeconds));
        }
        return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)assumeRoleRequest.build()).build();
    }

    public Set<String> variables() {
        return new HashSet<String>(Arrays.asList(this.accessKeyVariable, this.secretKeyVariable, SESSION_TOKEN_VARIABLE_NAME));
    }

    @Symbol(value={"aws"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<AmazonWebServicesCredentials> {
        protected Class<AmazonWebServicesCredentials> type() {
            return AmazonWebServicesCredentials.class;
        }

        public String getDisplayName() {
            return "AWS access key and secret";
        }

        public boolean requiresWorkspace() {
            return false;
        }
    }
}

